/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveJavaMemberHandler
implements MoveMemberHandler {
    @Override
    @Nullable
    public MoveMembersProcessor.MoveMembersUsageInfo getUsage(@NotNull PsiMember member, @NotNull PsiReference psiReference, @NotNull Set<PsiMember> membersToMove, @NotNull PsiClass targetClass) {
        PsiElement ref = psiReference.getElement();
        if (ref instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
                if (!RefactoringUtil.isInMovedElement((PsiElement)refExpr, membersToMove)) {
                    if (qualifier != null) {
                        return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, null, (PsiElement)qualifier, psiReference);
                    }
                } else if (qualifier instanceof PsiReferenceExpression && member.getContainingClass() != null && ((PsiReferenceExpression)qualifier).isReferenceTo((PsiElement)member.getContainingClass())) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
                }
            } else {
                if (qualifier == null) {
                    return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)refExpr, psiReference);
                }
                return new MoveMembersProcessor.MoveMembersUsageInfo(member, (PsiElement)refExpr, targetClass, (PsiElement)qualifier, psiReference);
            }
        }
        return null;
    }

    @Override
    public void checkConflictsOnUsage(@NotNull MoveMembersProcessor.MoveMembersUsageInfo usageInfo, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MoveMembersOptions moveMembersOptions, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiReference reference;
        PsiElement element = usageInfo.getElement();
        if (element == null) {
            return;
        }
        PsiMember member = usageInfo.member;
        if (element instanceof PsiReferenceExpression) {
            PsiExpression qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
            PsiClass accessObjectClass = null;
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
            }
            if (!JavaResolveUtil.isAccessible(member, targetClass, modifierListCopy, element, accessObjectClass, null)) {
                String newVisibility = moveMembersOptions.getExplicitMemberVisibility();
                String visibility = newVisibility != null ? newVisibility : VisibilityUtil.getVisibilityStringToDisplay((PsiMember)member);
                String message2 = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), visibility, RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element), (boolean)true)});
                conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
        }
        if (member instanceof PsiField && targetClass.isInterface()) {
            ReadWriteAccessDetector.Access access;
            ReadWriteAccessDetector accessDetector = ReadWriteAccessDetector.findDetector((PsiElement)member);
            if (accessDetector != null && (access = accessDetector.getExpressionAccess(element)) != ReadWriteAccessDetector.Access.Read) {
                String message3 = RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true) + " has write access but is moved to an interface";
                conflicts.putValue((Object)element, (Object)CommonRefactoringUtil.capitalize((String)message3));
            }
        } else if (member instanceof PsiField && usageInfo.reference instanceof PsiExpression && member.hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)usageInfo.reference)) && !RefactoringHierarchyUtil.willBeInTargetClass(usageInfo.reference, membersToMove, targetClass, true)) {
            conflicts.putValue((Object)usageInfo.member, (Object)"final variable initializer won't be available after move.");
        }
        if (MoveJavaMemberHandler.toBeConvertedToEnum(moveMembersOptions, member, targetClass) && !MoveJavaMemberHandler.isEnumAcceptable(element, targetClass)) {
            conflicts.putValue((Object)element, (Object)"Enum type won't be applicable in the current context");
        }
        if ((reference = usageInfo.getReference()) != null) {
            RefactoringConflictsUtil.checkAccessibilityConflicts(reference, member, modifierListCopy, targetClass, membersToMove, conflicts);
        }
    }

    private static boolean isEnumAcceptable(PsiElement element, PsiClass targetClass) {
        ExpectedTypeInfo[] types;
        if (element instanceof PsiExpression && (types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)element, false)).length == 1) {
            PsiType type2 = types[0].getType();
            return type2.isAssignableFrom((PsiType)JavaPsiFacade.getElementFactory((Project)element.getProject()).createType(targetClass));
        }
        return false;
    }

    @Override
    public void checkConflictsOnMember(@NotNull PsiMember member, @Nullable String newVisibility, @Nullable PsiModifierList modifierListCopy, @NotNull PsiClass targetClass, @NotNull Set<PsiMember> membersToMove, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (member instanceof PsiMethod && MoveJavaMemberHandler.hasMethod(targetClass, (PsiMethod)member) || member instanceof PsiField && MoveJavaMemberHandler.hasField(targetClass, (PsiField)member)) {
            String message2 = RefactoringBundle.message((String)"0.already.exists.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflicts.putValue((Object)member, (Object)CommonRefactoringUtil.capitalize((String)message2));
        }
        RefactoringConflictsUtil.checkUsedElements(member, (PsiElement)member, membersToMove, null, targetClass, (PsiElement)targetClass, conflicts);
    }

    protected static boolean hasMethod(PsiClass targetClass, PsiMethod method) {
        PsiMethod[] targetClassMethods;
        for (PsiMethod candidate : targetClassMethods = targetClass.findMethodsByName(method.getName(), true)) {
            if (candidate == method || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)method.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)candidate.getSignature(PsiSubstitutor.EMPTY))) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasField(PsiClass targetClass, PsiField field) {
        PsiField fieldByName = targetClass.findFieldByName(field.getName(), true);
        return fieldByName != null && fieldByName != field;
    }

    @Override
    public boolean changeExternalUsage(@NotNull MoveMembersOptions options, @NotNull MoveMembersProcessor.MoveMembersUsageInfo usage) {
        PsiElement element = usage.getElement();
        if (element == null || !element.isValid()) {
            return true;
        }
        if (usage.reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)usage.reference;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            if (qualifier != null) {
                if (usage.qualifierClass != null && PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiSwitchLabelStatement.class) == null) {
                    MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
                } else {
                    Project project = element.getProject();
                    PsiClass targetClass = JavaPsiFacade.getInstance((Project)project).findClass(options.getTargetClassName(), element.getResolveScope());
                    if (targetClass != null) {
                        PsiReferenceParameterList parameterList = refExpr.getParameterList();
                        if ((targetClass.isEnum() || PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)element, (boolean)true)) && parameterList != null && parameterList.getTypeArguments().length == 0 && !(refExpr instanceof PsiMethodReferenceExpression)) {
                            refExpr.setQualifierExpression(null);
                        } else {
                            MoveJavaMemberHandler.changeQualifier(refExpr, targetClass, usage.member);
                        }
                    }
                }
            } else if (!(usage.qualifierClass == null || usage.qualifierClass.isEnum() && PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiSwitchLabelStatement.class) != null)) {
                MoveJavaMemberHandler.changeQualifier(refExpr, usage.qualifierClass, usage.member);
            }
            return true;
        }
        return false;
    }

    protected static void changeQualifier(PsiReferenceExpression refExpr, PsiClass aClass, PsiMember member) throws IncorrectOperationException {
        if (RefactoringUtil.hasOnDemandStaticImport((PsiElement)refExpr, aClass) && !(refExpr instanceof PsiMethodReferenceExpression)) {
            refExpr.setQualifierExpression(null);
        } else if (!ImportsUtil.hasStaticImportOn((PsiElement)refExpr, (PsiMember)member, (boolean)false) || refExpr.getQualifierExpression() != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)refExpr.getProject());
            refExpr.setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
        }
    }

    @Override
    @NotNull
    public PsiMember doMove(@NotNull MoveMembersOptions options, @NotNull PsiMember member, PsiElement anchor, @NotNull PsiClass targetClass) {
        PsiMember memberCopy;
        if (member instanceof PsiVariable) {
            ((PsiVariable)member).normalizeDeclaration();
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)member, true);
        if (MoveJavaMemberHandler.toBeConvertedToEnum(options, member, targetClass)) {
            memberCopy = EnumConstantsUtil.createEnumConstant(targetClass, member.getName(), ((PsiVariable)member).getInitializer());
        } else {
            memberCopy = (PsiMember)member.copy();
            PsiClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !targetClass.isInterface()) {
                PsiModifierList list = memberCopy.getModifierList();
                assert (list != null);
                list.setModifierProperty("static", member.hasModifierProperty("static"));
                list.setModifierProperty("final", member.hasModifierProperty("final"));
                VisibilityUtil.setVisibility((PsiModifierList)list, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)member.getModifierList()));
            }
        }
        member.delete();
        return anchor != null ? (PsiMember)targetClass.addAfter((PsiElement)memberCopy, anchor) : (PsiMember)targetClass.add((PsiElement)memberCopy);
    }

    private static boolean toBeConvertedToEnum(@NotNull MoveMembersOptions options, @NotNull PsiMember member, @NotNull PsiClass targetClass) {
        return options.makeEnumConstant() && member instanceof PsiVariable && EnumConstantsUtil.isSuitableForEnumConstant(((PsiVariable)member).getType(), targetClass);
    }

    @Override
    public void decodeContextInfo(@NotNull PsiElement scope) {
        ChangeContextUtil.decodeContextInfo(scope, null, null);
    }

    @Override
    @Nullable
    public PsiElement getAnchor(@NotNull PsiMember member, final @NotNull PsiClass targetClass, final Set<PsiMember> membersToMove) {
        if (member instanceof PsiField && member.hasModifierProperty("static")) {
            final ArrayList afterFields = new ArrayList();
            PsiExpression psiExpression = ((PsiField)member).getInitializer();
            if (psiExpression != null) {
                psiExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        PsiField psiField;
                        super.visitReferenceExpression(expression2);
                        PsiElement psiElement = expression2.resolve();
                        if (psiElement instanceof PsiField && ((psiField = (PsiField)psiElement).getContainingClass() == targetClass || membersToMove.contains(psiField)) && !afterFields.contains(psiField)) {
                            afterFields.add(psiField);
                        }
                    }
                });
            }
            if (!afterFields.isEmpty()) {
                afterFields.sort((o1, o2) -> -PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2));
                return (PsiElement)afterFields.get(0);
            }
            ArrayList<PsiField> beforeFields = new ArrayList<PsiField>();
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)targetClass))) {
                PsiField fieldWithReference = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiField.class);
                if (fieldWithReference == null || afterFields.contains(fieldWithReference) || fieldWithReference.getContainingClass() != targetClass) continue;
                beforeFields.add(fieldWithReference);
            }
            beforeFields.sort(PsiUtil.BY_POSITION);
            if (!beforeFields.isEmpty()) {
                return ((PsiField)beforeFields.get(0)).getPrevSibling();
            }
        }
        return null;
    }
}

