/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMoveFilesOrDirectoriesHandler
extends MoveFilesOrDirectoriesHandler {
    public PsiElement adjustTargetForMove(DataContext dataContext, PsiElement targetContainer) {
        PsiDirectory[] directories;
        Module module;
        if (targetContainer instanceof PsiPackage && (module = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext)) != null && (directories = ((PsiPackage)targetContainer).getDirectories(GlobalSearchScope.moduleScope((Module)module))).length == 1) {
            return directories[0];
        }
        return super.adjustTargetForMove(dataContext, targetContainer);
    }

    public boolean canMove(PsiElement[] elements, PsiElement targetContainer, @Nullable PsiReference reference) {
        if (reference != null) {
            return false;
        }
        if (elements.length > 1) {
            elements = JavaMoveFilesOrDirectoriesHandler.preprocess(elements);
        }
        return super.canMove(elements, targetContainer, reference);
    }

    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        sourceElements = JavaMoveFilesOrDirectoriesHandler.preprocess(sourceElements);
        return super.adjustForMove(project, sourceElements, targetElement);
    }

    private static PsiElement[] preprocess(PsiElement[] sourceElements) {
        LinkedHashSet<PsiElement> result = new LinkedHashSet<PsiElement>();
        for (PsiElement sourceElement : sourceElements) {
            result.add((PsiElement)(sourceElement instanceof PsiClass ? sourceElement.getContainingFile() : sourceElement));
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        if ((elements = super.adjustForMove(project, elements, targetContainer)) == null) {
            return;
        }
        MoveFilesOrDirectoriesUtil.doMove((Project)project, (PsiElement[])elements, (PsiElement[])new PsiElement[]{targetContainer}, (MoveCallback)callback, elements1 -> (PsiElement[])WriteCommandAction.writeCommandAction((Project)project).withName(JavaRefactoringBundle.message((String)"move.files.regrouping.command.name", (Object[])new Object[0])).compute(() -> {
            ArrayList<Object> adjustedElements = new ArrayList<Object>();
            int length = ((PsiElement[])elements1).length;
            for (int i = 0; i < length; ++i) {
                PsiClass topLevelClass;
                PsiElement element = elements1[i];
                if (element instanceof PsiClass && (topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element)) != null) {
                    elements1[i] = topLevelClass;
                    PsiFile containingFile = JavaMoveFilesOrDirectoriesHandler.obtainContainingFile((PsiElement)topLevelClass, elements1);
                    if (containingFile != null) {
                        adjustedElements.add(containingFile);
                        continue;
                    }
                }
                adjustedElements.add(element);
            }
            return PsiUtilCore.toPsiElementArray(adjustedElements);
        }));
    }

    @Nullable
    private static PsiFile obtainContainingFile(@NotNull PsiElement element, PsiElement[] elements) {
        PsiFile containingFile = element.getContainingFile();
        PsiClass[] classes2 = ((PsiClassOwner)containingFile).getClasses();
        HashSet<PsiClass> nonMovedClasses = new HashSet<PsiClass>();
        for (PsiClass aClass : classes2) {
            if (ArrayUtilRt.find((Object[])elements, (Object)aClass) >= 0) continue;
            nonMovedClasses.add(aClass);
        }
        if (nonMovedClasses.isEmpty()) {
            return containingFile;
        }
        PsiDirectory containingDirectory = containingFile.getContainingDirectory();
        if (containingDirectory != null) {
            try {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface(containingDirectory, ((PsiClass)element).getName());
                PsiElement createdClass = containingDirectory.add(element);
                element.delete();
                return createdClass.getContainingFile();
            }
            catch (IncorrectOperationException e) {
                Iterator iterator = nonMovedClasses.iterator();
                PsiClass nonMovedClass = (PsiClass)iterator.next();
                PsiFile createdFile = containingDirectory.add((PsiElement)nonMovedClass).getContainingFile();
                nonMovedClass.delete();
                while (iterator.hasNext()) {
                    PsiClass currentClass = (PsiClass)iterator.next();
                    createdFile.add((PsiElement)currentClass);
                    currentClass.delete();
                }
                return containingFile;
            }
        }
        return null;
    }
}

