/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingMoveDestination;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleRootsMoveDestination
extends AutocreatingMoveDestination {
    private static final Logger LOG = Logger.getInstance(MultipleRootsMoveDestination.class);

    public MultipleRootsMoveDestination(PackageWrapper aPackage) {
        super(aPackage);
    }

    @Override
    @NotNull
    public PackageWrapper getTargetPackage() {
        return this.myPackage;
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiDirectory source) throws IncorrectOperationException {
        return this.getOrCreateDirectoryForSource(source.getVirtualFile());
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiFile source) throws IncorrectOperationException {
        return this.getOrCreateDirectoryForSource(source.getVirtualFile());
    }

    public PsiDirectory getTargetIfExists(@NotNull PsiFile source) {
        return this.findTargetDirectoryForSource(source.getVirtualFile());
    }

    public String verify(PsiFile source) {
        VirtualFile sourceRootForFile;
        VirtualFile virtualFile = source.getVirtualFile();
        if (virtualFile.isDirectory()) {
            virtualFile = virtualFile.getParent();
            LOG.assertTrue(virtualFile.isDirectory());
        }
        if ((sourceRootForFile = this.myFileIndex.getSourceRootForFile(virtualFile)) == null) {
            return "";
        }
        return this.checkCanCreateInSourceRoot(sourceRootForFile);
    }

    @Nullable
    public String verify(PsiDirectory source) {
        VirtualFile virtualFile = source.getVirtualFile();
        VirtualFile sourceRootForFile = this.myFileIndex.getSourceRootForFile(virtualFile);
        if (sourceRootForFile == null) {
            return "";
        }
        if (virtualFile.equals(sourceRootForFile)) {
            return null;
        }
        return this.checkCanCreateInSourceRoot(sourceRootForFile);
    }

    @Nullable
    public String verify(PsiPackage source) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = source.getDirectories()) {
            String s = this.verify(directory);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public void analyzeModuleConflicts(@NotNull Collection<? extends PsiElement> elements, @NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
    }

    public boolean isTargetAccessible(@NotNull Project project, @NotNull VirtualFile place) {
        return true;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return this.findTargetDirectoryForSource(source.getVirtualFile());
    }

    private PsiDirectory findTargetDirectoryForSource(VirtualFile file) {
        VirtualFile sourceRoot = this.myFileIndex.getSourceRootForFile(file);
        LOG.assertTrue(sourceRoot != null);
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, sourceRoot);
    }

    private PsiDirectory getOrCreateDirectoryForSource(VirtualFile file) throws IncorrectOperationException {
        return RefactoringUtil.createPackageDirectoryInSourceRoot(this.myPackage, Objects.requireNonNull(this.myFileIndex.getSourceRootForFile(file)));
    }
}

