/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.ReorderingUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VariableExtractor {
    private static final Logger LOG = Logger.getInstance(VariableExtractor.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final IntroduceVariableSettings mySettings;
    @NotNull
    private final PsiExpression myExpression;
    @NotNull
    private PsiElement myAnchor;
    private final PsiElement myContainer;
    private final PsiExpression @NotNull [] myOccurrences;
    private final boolean myReplaceSelf;
    @NotNull
    private final FieldConflictsResolver myFieldConflictsResolver;
    @Nullable
    private final LogicalPosition myPosition;

    private VariableExtractor(@NotNull Project project, @NotNull PsiExpression expression2, @Nullable Editor editor, @NotNull PsiElement anchorStatement, PsiExpression @NotNull [] occurrences, @NotNull IntroduceVariableSettings settings) {
        this.myProject = project;
        this.myExpression = expression2;
        this.myEditor = editor;
        this.myOccurrences = occurrences;
        this.mySettings = settings;
        this.myContainer = anchorStatement.getParent();
        this.myAnchor = VariableExtractor.correctAnchor(expression2, anchorStatement, occurrences);
        this.myReplaceSelf = settings.isReplaceLValues() || !RefactoringUtil.isAssignmentLHS((PsiElement)expression2);
        PsiCodeBlock newDeclarationScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)this.myContainer, PsiCodeBlock.class, (boolean)false);
        this.myFieldConflictsResolver = new FieldConflictsResolver(settings.getEnteredName(), newDeclarationScope);
        this.myPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : null;
    }

    @NotNull
    private SmartPsiElementPointer<PsiVariable> extractVariable() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiExpression newExpr = this.myFieldConflictsResolver.fixInitializer(this.myExpression);
        if (this.myAnchor == this.myExpression) {
            this.myAnchor = newExpr;
        }
        PsiExpression initializer = RefactoringUtil.unparenthesizeExpression(newExpr);
        SmartTypePointer selectedType = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.mySettings.getSelectedType());
        initializer = IntroduceVariableBase.simplifyVariableInitializer(initializer, selectedType.getType());
        CommentTracker commentTracker = new CommentTracker();
        commentTracker.markUnchanged(initializer);
        initializer = (PsiExpression)initializer.copy();
        PsiType type2 = VariableExtractor.stripNullabilityAnnotationsFromTargetType(selectedType, newExpr);
        PsiElement declaration2 = this.createDeclaration(type2, this.mySettings.getEnteredName(), initializer);
        this.replaceOccurrences(newExpr);
        this.ensureCodeBlock();
        PsiVariable var = this.addVariable(declaration2, initializer);
        if (this.myAnchor instanceof PsiExpressionStatement && ExpressionUtils.isReferenceTo(((PsiExpressionStatement)this.myAnchor).getExpression(), var)) {
            commentTracker.deleteAndRestoreComments(this.myAnchor);
            if (this.myEditor != null) {
                assert (this.myPosition != null);
                this.myEditor.getCaretModel().moveToLogicalPosition(this.myPosition);
                this.myEditor.getCaretModel().moveToOffset(var.getTextRange().getEndOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                this.myEditor.getSelectionModel().removeSelection();
            }
        }
        this.highlight(var);
        if (!(var instanceof PsiPatternVariable)) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)this.mySettings.isDeclareFinal());
            if (this.mySettings.isDeclareVarType()) {
                PsiTypeElement typeElement = var.getTypeElement();
                LOG.assertTrue(typeElement != null);
                IntroduceVariableBase.expandDiamondsAndReplaceExplicitTypeWithVar(typeElement, (PsiElement)var);
            }
        }
        this.myFieldConflictsResolver.fix();
        return SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)var);
    }

    private void ensureCodeBlock() {
        if (this.myAnchor instanceof PsiStatement && RefactoringUtil.isLoopOrIf(this.myAnchor.getParent())) {
            this.myAnchor = BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)this.myAnchor);
        }
        if (this.myAnchor instanceof PsiInstanceOfExpression && PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myExpression) instanceof PsiTypeCastExpression) {
            return;
        }
        if (this.myAnchor instanceof PsiExpression) {
            CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)this.myAnchor);
            if (surrounder == null) {
                throw new RuntimeExceptionWithAttachments("Cannot ensure code block: myAnchor type is " + this.myAnchor.getClass() + "; parent type is " + this.myAnchor.getParent().getClass(), new Attachment[]{new Attachment("context.txt", this.myContainer.getText())});
            }
            CodeBlockSurrounder.SurroundResult result = surrounder.surround();
            this.myAnchor = result.getAnchor();
        }
    }

    private void highlight(@NotNull PsiVariable var) {
        if (this.myEditor != null) {
            PsiElement[] occurrences = PsiTreeUtil.collectElements((PsiElement)this.myContainer, e -> e instanceof PsiReference && ((PsiReference)e).isReferenceTo((PsiElement)var));
            IntroduceVariableBase.highlightReplacedOccurrences(this.myProject, this.myEditor, occurrences);
        }
    }

    private void replaceOccurrences(PsiExpression newExpr) {
        assert (this.myAnchor.isValid());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiExpression ref = elementFactory.createExpressionFromText(this.mySettings.getEnteredName(), null);
        boolean needReplaceSelf = this.myReplaceSelf;
        if (this.mySettings.isReplaceAllOccurrences()) {
            for (PsiExpression occurrence : this.myOccurrences) {
                PsiExpression correctedOccurrence = occurrence.equals(this.myExpression) ? newExpr : occurrence;
                correctedOccurrence = RefactoringUtil.outermostParenthesizedExpression(correctedOccurrence);
                if (!this.mySettings.isReplaceLValues() && RefactoringUtil.isAssignmentLHS((PsiElement)correctedOccurrence)) continue;
                PsiElement replacement = IntroduceVariableBase.replace(correctedOccurrence, ref, this.myProject);
                if (this.myAnchor.isValid()) continue;
                this.myAnchor = replacement;
            }
            needReplaceSelf &= newExpr instanceof PsiPolyadicExpression && newExpr.isValid() && !newExpr.isPhysical();
        }
        if (needReplaceSelf) {
            PsiElement replacement = IntroduceVariableBase.replace(newExpr, ref, this.myProject);
            if (!this.myAnchor.isValid()) {
                this.myAnchor = replacement;
            }
        }
    }

    @NotNull
    private PsiVariable addVariable(PsiElement declaration2, @NotNull PsiExpression initializer) {
        declaration2 = VariableExtractor.addDeclaration(declaration2, initializer, this.myAnchor);
        declaration2 = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(declaration2);
        return (PsiVariable)(declaration2 instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)declaration2).getDeclaredElements()[0] : declaration2);
    }

    @NotNull
    private PsiElement createDeclaration(@NotNull PsiType type2, @NotNull String name2, PsiExpression initializer) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        if (this.myAnchor instanceof PsiInstanceOfExpression && initializer instanceof PsiTypeCastExpression) {
            PsiTypeElement castType = Objects.requireNonNull(((PsiTypeCastExpression)initializer).getCastType());
            return elementFactory.createExpressionFromText(((PsiInstanceOfExpression)this.myAnchor).getOperand().getText() + " instanceof " + castType.getText() + " " + name2, this.myContainer);
        }
        if (this.myContainer instanceof PsiClass) {
            PsiField declaration2 = elementFactory.createField(name2, type2);
            declaration2.setInitializer(initializer);
            return declaration2;
        }
        return elementFactory.createVariableDeclarationStatement(name2, type2, initializer, this.myContainer);
    }

    private static PsiElement addDeclaration(PsiElement declaration2, PsiExpression initializer, @NotNull PsiElement anchor) {
        PsiElement[] declaredElements;
        if (anchor instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()).length > 1) {
            final int[] usedFirstVar = new int[]{-1};
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    int i = ArrayUtilRt.find((Object[])declaredElements, (Object)expression2.resolve());
                    if (i > -1) {
                        usedFirstVar[0] = Math.max(i, usedFirstVar[0]);
                    }
                    super.visitReferenceExpression(expression2);
                }
            });
            if (usedFirstVar[0] > -1) {
                PsiVariable psiVariable = (PsiVariable)declaredElements[usedFirstVar[0]];
                psiVariable.normalizeDeclaration();
                PsiDeclarationStatement parDeclarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
                return anchor.getParent().addAfter(declaration2, (PsiElement)parDeclarationStatement);
            }
        }
        if (anchor instanceof PsiInstanceOfExpression && declaration2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression newInstanceOf = (PsiInstanceOfExpression)anchor.replace(declaration2);
            return ((PsiTypeTestPattern)Objects.requireNonNull(newInstanceOf.getPattern())).getPatternVariable();
        }
        if (anchor instanceof PsiResourceListElement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)declaration2;
            PsiLocalVariable localVariable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
            PsiResourceVariable resourceVariable = JavaPsiFacade.getElementFactory((Project)anchor.getProject()).createResourceVariable(localVariable.getName(), localVariable.getType(), initializer, anchor);
            return anchor.replace((PsiElement)resourceVariable);
        }
        PsiElement parent = anchor.getParent();
        if (parent == null) {
            throw new IllegalStateException("Unexpectedly anchor has no parent. Anchor class: " + anchor.getClass());
        }
        return parent.addBefore(declaration2, anchor);
    }

    @NotNull
    private static PsiType stripNullabilityAnnotationsFromTargetType(@NotNull SmartTypePointer selectedType, @NotNull PsiExpression expression2) {
        PsiType type2 = selectedType.getType();
        if (type2 == null) {
            throw new IncorrectOperationException("Unexpected empty type pointer");
        }
        PsiDeclarationStatement probe = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createVariableDeclarationStatement("x", (PsiType)TypeUtils.getObjectType((PsiElement)expression2), null, (PsiElement)expression2);
        Project project = expression2.getProject();
        NullabilityAnnotationInfo nullabilityAnnotationInfo = NullableNotNullManager.getInstance((Project)project).findExplicitNullability((PsiModifierListOwner)((PsiLocalVariable)probe.getDeclaredElements()[0]));
        NullabilityAnnotationInfo info = DfaPsiUtil.getTypeNullabilityInfo(type2);
        if (info != null && nullabilityAnnotationInfo != null && info.getNullability() != nullabilityAnnotationInfo.getNullability() && ArrayUtil.contains((Object)info.getAnnotation(), (Object[])type2.getAnnotations())) {
            return type2.annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])new PsiAnnotation[]{info.getAnnotation()}));
        }
        return type2.annotate(TypeAnnotationProvider.EMPTY);
    }

    @NotNull
    private static PsiElement correctAnchor(@NotNull PsiExpression expr2, @NotNull PsiElement anchor, PsiExpression @NotNull [] occurrences) {
        PsiExpression ancestorCandidate;
        PsiWhileStatement whileStatement;
        PsiExpression condition2;
        PsiInstanceOfExpression candidate;
        PsiTypeCastExpression cast;
        if (!expr2.isPhysical() && (expr2 = (PsiExpression)ObjectUtils.tryCast((Object)expr2.getUserData(ElementToWorkOn.PARENT), PsiExpression.class)) == null) {
            return anchor;
        }
        if (anchor instanceof PsiSwitchLabelStatementBase) {
            PsiSwitchBlock block = ((PsiSwitchLabelStatementBase)anchor).getEnclosingSwitchBlock();
            if (block == null) {
                return anchor;
            }
            anchor = block;
            if (anchor instanceof PsiExpression) {
                expr2 = (PsiExpression)anchor;
            }
        }
        Set allOccurrences = ((StreamEx)StreamEx.of((Object[])occurrences).filter(PsiElement::isPhysical)).append((Object)expr2).toSet();
        PsiExpression firstOccurrence = Collections.min(allOccurrences, Comparator.comparing(e -> e.getTextRange().getStartOffset()));
        if (HighlightingFeature.PATTERNS.isAvailable(anchor) && (cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)firstOccurrence), PsiTypeCastExpression.class)) != null && !(cast.getType() instanceof PsiPrimitiveType) && !(PsiUtil.skipParenthesizedExprUp((PsiElement)firstOccurrence.getParent()) instanceof PsiExpressionStatement) && (candidate = InstanceOfUtils.findPatternCandidate(cast)) != null && allOccurrences.stream().map(occ -> (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)occ), PsiTypeCastExpression.class)).allMatch(occ -> occ != null && (occ == firstOccurrence || InstanceOfUtils.findPatternCandidate(occ) == candidate))) {
            return candidate;
        }
        if (anchor instanceof PsiWhileStatement && (condition2 = (whileStatement = (PsiWhileStatement)anchor).getCondition()) != null && allOccurrences.stream().allMatch(occurrence -> PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)occurrence, (boolean)true)) && firstOccurrence != null && PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)firstOccurrence, (boolean)false)) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2), PsiPolyadicExpression.class);
            if (polyadic != null && JavaTokenType.ANDAND.equals(polyadic.getOperationTokenType())) {
                PsiExpression operand2 = (PsiExpression)ContainerUtil.find((Object[])polyadic.getOperands(), op -> PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)firstOccurrence, (boolean)false));
                LOG.assertTrue((operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2)) != null);
                return operand2;
            }
            return condition2;
        }
        if (firstOccurrence != null && CodeBlockSurrounder.canSurround(firstOccurrence) && !PsiUtil.isAccessedForWriting((PsiExpression)firstOccurrence) && PsiTreeUtil.isAncestor((PsiElement)anchor, (PsiElement)(ancestorCandidate = ExpressionUtils.getTopLevelExpression(firstOccurrence)), (boolean)false)) {
            PsiElement extractable;
            PsiElement statement = RefactoringUtil.getParentStatement((PsiElement)ancestorCandidate, false);
            PsiElement psiElement = extractable = statement == null ? PsiTreeUtil.getParentOfType((PsiElement)ancestorCandidate, PsiField.class) : statement;
            if (allOccurrences.stream().allMatch(occurrence -> PsiTreeUtil.isAncestor((PsiElement)extractable, (PsiElement)occurrence, (boolean)false) && (!PsiTreeUtil.isAncestor((PsiElement)ancestorCandidate, (PsiElement)occurrence, (boolean)false) || ReorderingUtils.canExtract(ancestorCandidate, occurrence) == ThreeState.NO))) {
                return firstOccurrence;
            }
        }
        if (anchor instanceof PsiTryStatement && firstOccurrence != null) {
            PsiResourceList resourceList = ((PsiTryStatement)anchor).getResourceList();
            PsiElement parent = firstOccurrence.getParent();
            if (resourceList != null && parent instanceof PsiResourceExpression && parent.getParent() == resourceList && InheritanceUtil.isInheritor((PsiType)firstOccurrence.getType(), (String)"java.lang.AutoCloseable")) {
                return parent;
            }
        }
        if (anchor.getParent() instanceof PsiSwitchLabeledRuleStatement) {
            return ExpressionUtils.getTopLevelExpression(expr2);
        }
        if (RefactoringUtil.isLoopOrIf(anchor.getParent())) {
            return anchor;
        }
        PsiElement child = VariableExtractor.locateAnchor(anchor);
        if (IntroduceVariableBase.isFinalVariableOnLHS(expr2)) {
            child = child.getNextSibling();
        }
        return child == null ? anchor : child;
    }

    private static PsiElement locateAnchor(PsiElement child) {
        PsiElement prev;
        while (child != null && !((prev = child.getPrevSibling()) instanceof PsiStatement) && !PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.LBRACE)) {
            child = prev;
        }
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getNextSibling();
        }
        return child;
    }

    @Nullable
    public static PsiVariable introduce(@NotNull Project project, @NotNull PsiExpression expr2, @Nullable Editor editor, @NotNull PsiElement anchorStatement, PsiExpression @NotNull [] occurrences, @NotNull IntroduceVariableSettings settings) {
        Computable computation = new VariableExtractor(project, expr2, editor, anchorStatement, occurrences, settings)::extractVariable;
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)ApplicationManager.getApplication().runWriteAction(computation);
        return pointer != null ? (PsiVariable)pointer.getElement() : null;
    }
}

