/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class LocalToFieldHandler {
    private static final Logger LOG = Logger.getInstance(LocalToFieldHandler.class);
    private final Project myProject;
    private final boolean myIsConstant;

    public LocalToFieldHandler(Project project, boolean isConstant) {
        this.myProject = project;
        this.myIsConstant = isConstant;
    }

    protected abstract BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass var1, PsiLocalVariable var2, PsiExpression[] var3, boolean var4);

    public boolean convertLocalToField(final PsiLocalVariable local, final Editor editor) {
        boolean shouldSuggestDialog;
        boolean tempIsStatic = this.myIsConstant;
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
        for (PsiElement parent = local.getParent(); parent != null && parent.getContainingFile() != null; parent = parent.getParent()) {
            if (!(!(parent instanceof PsiClass) || this.myIsConstant && parent instanceof PsiAnonymousClass)) {
                classes2.add((PsiClass)parent);
            }
            if (parent instanceof PsiFile && FileTypeUtils.isInServerPageFile((PsiElement)parent)) {
                String message2 = JavaRefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{LocalToFieldHandler.getRefactoringName()});
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message2, (String)LocalToFieldHandler.getRefactoringName(), (String)"refactoring.convertLocal");
                return false;
            }
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            tempIsStatic = true;
        }
        if (classes2.isEmpty()) {
            return false;
        }
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        boolean bl = shouldSuggestDialog = activeIntroducer instanceof InplaceIntroduceConstantPopup && activeIntroducer.startsOnTheSameElement(null, (PsiNameIdentifierOwner)local);
        if (classes2.size() == 1 || ApplicationManager.getApplication().isUnitTestMode() || shouldSuggestDialog) {
            if (this.convertLocalToField(local, (PsiClass)classes2.get(this.getChosenClassIndex(classes2)), editor, tempIsStatic)) {
                return false;
            }
        } else {
            final boolean isStatic = tempIsStatic;
            PsiClass firstClass = (PsiClass)classes2.get(0);
            PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes2, firstClass);
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])classes2.toArray(PsiClass.EMPTY_ARRAY)), (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)("Choose class to introduce " + (this.myIsConstant ? "constant" : "field")), (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass aClass) {
                    AnonymousTargetClassPreselectionUtil.rememberSelection(aClass, aClass);
                    LocalToFieldHandler.this.convertLocalToField(local, aClass, editor, isStatic);
                    return false;
                }
            }, (PsiElement)preselection).showInBestPositionFor(editor);
        }
        return true;
    }

    protected int getChosenClassIndex(List<PsiClass> classes2) {
        return classes2.size() - 1;
    }

    private boolean convertLocalToField(PsiLocalVariable local, PsiClass aClass, Editor editor, boolean isStatic) {
        BaseExpressionToFieldHandler.Settings settings;
        PsiExpression[] occurences = CodeInsightUtil.findReferenceExpressions(RefactoringUtil.getVariableScope(local), (PsiElement)local);
        if (editor != null) {
            RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurences, editor);
        }
        if ((settings = this.showRefactoringDialog(aClass, local, occurences, isStatic)) == null) {
            return true;
        }
        PsiClass destinationClass = settings.getDestinationClass();
        boolean rebindNeeded = false;
        if (destinationClass != null) {
            aClass = destinationClass;
            rebindNeeded = true;
        }
        PsiClass aaClass = aClass;
        boolean rebindNeeded1 = rebindNeeded;
        IntroduceFieldRunnable runnable = new IntroduceFieldRunnable(rebindNeeded1, local, aaClass, settings, isStatic, occurences);
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(runnable), LocalToFieldHandler.getRefactoringName(), null);
        return false;
    }

    private static PsiField createField(PsiLocalVariable local, PsiType forcedType, String fieldName, boolean includeInitializer) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("private int ");
        pattern.append(fieldName);
        if (local.getInitializer() == null) {
            includeInitializer = false;
        }
        if (includeInitializer) {
            pattern.append("=0");
        }
        pattern.append(";");
        Project project = local.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        try {
            PsiModifierList sourceModifierList;
            PsiField field = factory.createFieldFromText(pattern.toString(), null);
            field.getTypeElement().replace((PsiElement)factory.createTypeElement(forcedType));
            if (includeInitializer) {
                PsiExpression initializer = RefactoringUtil.convertInitializerToNormalExpression(local.getInitializer(), forcedType);
                field.getInitializer().replace((PsiElement)initializer);
            }
            LOG.assertTrue((sourceModifierList = local.getModifierList()) != null);
            PsiModifierList fieldModifierList = field.getModifierList();
            LOG.assertTrue(fieldModifierList != null);
            GenerateMembersUtil.copyAnnotations(sourceModifierList, fieldModifierList, new String[0]);
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiExpressionStatement createAssignment(PsiLocalVariable local, String fieldname, PsiElementFactory factory) {
        try {
            String pattern = fieldname + "=0;";
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, (PsiElement)local);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)local.getProject()).reformat((PsiElement)statement);
            PsiAssignmentExpression expr2 = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression initializer = RefactoringUtil.convertInitializerToNormalExpression(local.getInitializer(), local.getType());
            expr2.getRExpression().replace((PsiElement)initializer);
            return statement;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiStatement addInitializationToSetUp(PsiLocalVariable local, PsiField field, PsiElementFactory factory) throws IncorrectOperationException {
        PsiClass containingClass = field.getContainingClass();
        PsiMethod inClass = TestFrameworks.getInstance().findOrCreateSetUpMethod(containingClass);
        assert (inClass != null);
        PsiExpressionStatement assignment = LocalToFieldHandler.createAssignment(local, field.getName(), factory);
        PsiCodeBlock body2 = inClass.getBody();
        assert (body2 != null);
        ChangeContextUtil.encodeContextInfo((PsiElement)assignment, false);
        assignment = PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)local, (boolean)false) ? (PsiStatement)body2.addBefore((PsiElement)assignment, PsiTreeUtil.getParentOfType((PsiElement)local, PsiStatement.class)) : (PsiStatement)body2.add((PsiElement)assignment);
        ChangeContextUtil.decodeContextInfo((PsiElement)assignment, containingClass, factory.createExpressionFromText("this", null));
        LocalToFieldHandler.appendComments((PsiElement)local, (PsiElement)assignment);
        local.delete();
        return assignment;
    }

    private static PsiStatement addInitializationToConstructors(PsiLocalVariable local, PsiField field, PsiMethod enclosingConstructor, PsiElementFactory factory) throws IncorrectOperationException {
        PsiClass aClass = field.getContainingClass();
        PsiMethod[] constructors = aClass.getConstructors();
        PsiExpressionStatement assignment = LocalToFieldHandler.createAssignment(local, field.getName(), factory);
        PsiExpression thisAccessExpr = factory.createExpressionFromText("this", null);
        boolean added = false;
        for (PsiMethod constructor : constructors) {
            PsiCodeBlock body2;
            if (constructor == enclosingConstructor || (body2 = constructor.getBody()) == null) continue;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length > 0) {
                PsiExpression expression2;
                PsiStatement first = statements[0];
                if (first instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression) {
                    String text2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getText();
                    if ("this".equals(text2)) continue;
                    if ("super".equals(text2) && enclosingConstructor == null && PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)local, (boolean)false)) {
                        ChangeContextUtil.encodeContextInfo((PsiElement)assignment, false);
                        PsiStatement statement = (PsiStatement)body2.addAfter((PsiElement)assignment, (PsiElement)first);
                        ChangeContextUtil.decodeContextInfo((PsiElement)statement, aClass, thisAccessExpr);
                        LocalToFieldHandler.appendComments((PsiElement)local, (PsiElement)statement);
                        local.delete();
                        return statement;
                    }
                }
                if (enclosingConstructor == null && PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)local, (boolean)false)) {
                    ChangeContextUtil.encodeContextInfo((PsiElement)assignment, false);
                    PsiStatement statement = (PsiStatement)body2.addBefore((PsiElement)assignment, (PsiElement)first);
                    ChangeContextUtil.decodeContextInfo((PsiElement)statement, aClass, thisAccessExpr);
                    LocalToFieldHandler.appendComments((PsiElement)local, (PsiElement)statement);
                    local.delete();
                    return statement;
                }
            }
            ChangeContextUtil.encodeContextInfo((PsiElement)assignment, false);
            assignment = (PsiStatement)body2.add((PsiElement)assignment);
            ChangeContextUtil.decodeContextInfo((PsiElement)assignment, aClass, thisAccessExpr);
            added = true;
        }
        if (!added && enclosingConstructor == null) {
            if (aClass instanceof PsiAnonymousClass) {
                PsiClassInitializer classInitializer = (PsiClassInitializer)aClass.addAfter((PsiElement)factory.createClassInitializer(), (PsiElement)field);
                assignment = (PsiStatement)classInitializer.getBody().add((PsiElement)assignment);
            } else {
                PsiMethod constructor = (PsiMethod)aClass.add((PsiElement)factory.createConstructor());
                assignment = (PsiStatement)constructor.getBody().add((PsiElement)assignment);
            }
        }
        if (enclosingConstructor == null) {
            LocalToFieldHandler.appendComments((PsiElement)assignment, (PsiElement)local);
            local.delete();
        }
        return assignment;
    }

    private static void appendComments(PsiElement declarationStatement, PsiElement element) {
        LocalToFieldHandler.appendComments(declarationStatement, element, null);
    }

    private static void appendComments(PsiElement declarationStatement, PsiElement element, PsiElement unchanged) {
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)declarationStatement, PsiComment.class);
        PsiElement parent = element.getParent();
        for (PsiComment comment : comments) {
            if (PsiTreeUtil.isAncestor((PsiElement)unchanged, (PsiElement)comment, (boolean)false)) continue;
            parent.addBefore((PsiElement)comment, element);
        }
    }

    private static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"convert.local.to.field.title", (Object[])new Object[0]);
    }

    static class IntroduceFieldRunnable
    implements Runnable {
        private final String myVariableName;
        private final String myFieldName;
        private final boolean myRebindNeeded;
        private final PsiLocalVariable myLocal;
        private final Project myProject;
        private final PsiClass myDestinationClass;
        private final BaseExpressionToFieldHandler.Settings mySettings;
        private final BaseExpressionToFieldHandler.InitializationPlace myInitializerPlace;
        private final PsiExpression[] myOccurences;
        private PsiField myField;

        IntroduceFieldRunnable(boolean rebindNeeded, PsiLocalVariable local, PsiClass aClass, BaseExpressionToFieldHandler.Settings settings, boolean isStatic, PsiExpression[] occurrences) {
            this.myVariableName = local.getName();
            this.myFieldName = settings.getFieldName();
            this.myRebindNeeded = rebindNeeded;
            this.myLocal = local;
            this.myProject = local.getProject();
            this.myDestinationClass = aClass;
            this.mySettings = settings;
            this.myInitializerPlace = settings.getInitializerPlace();
            this.myOccurences = occurrences;
        }

        @Override
        public void run() {
            try {
                PsiExpressionStatement statement;
                ChangeContextUtil.encodeContextInfo((PsiElement)this.myDestinationClass, true);
                boolean rebindNeeded2 = !this.myVariableName.equals(this.myFieldName) || this.myRebindNeeded;
                PsiReference[] refs = rebindNeeded2 ? (PsiReference[])ReferencesSearch.search((PsiElement)this.myLocal, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY) : null;
                PsiMethod enclosingConstructor = BaseExpressionToFieldHandler.getEnclosingConstructor(this.myDestinationClass, (PsiElement)this.myLocal);
                this.myField = this.mySettings.isIntroduceEnumConstant() ? EnumConstantsUtil.createEnumConstant(this.myDestinationClass, this.myLocal, this.myFieldName) : LocalToFieldHandler.createField(this.myLocal, this.mySettings.getForcedType(), this.myFieldName, this.myInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
                this.myField = (PsiField)this.myDestinationClass.add((PsiElement)this.myField);
                BaseExpressionToFieldHandler.setModifiers(this.myField, this.mySettings);
                if (!this.mySettings.isIntroduceEnumConstant()) {
                    VisibilityUtil.fixVisibility((PsiExpression[])this.myOccurences, (PsiMember)this.myField, (String)this.mySettings.getFieldVisibility());
                }
                this.myLocal.normalizeDeclaration();
                PsiElement declarationStatement = this.myLocal.getParent();
                BaseExpressionToFieldHandler.InitializationPlace finalInitializerPlace = this.myLocal.getInitializer() == null ? BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION : this.myInitializerPlace;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
                switch (finalInitializerPlace) {
                    case IN_FIELD_DECLARATION: {
                        LocalToFieldHandler.appendComments(declarationStatement, (PsiElement)this.myField, (PsiElement)this.myLocal.getInitializer());
                        declarationStatement.delete();
                        break;
                    }
                    case IN_CURRENT_METHOD: {
                        statement = LocalToFieldHandler.createAssignment(this.myLocal, this.myFieldName, factory);
                        LocalToFieldHandler.appendComments(declarationStatement, declarationStatement, (PsiElement)this.myLocal.getInitializer());
                        if (declarationStatement instanceof PsiDeclarationStatement) {
                            declarationStatement.replace((PsiElement)statement);
                            break;
                        }
                        this.myLocal.replace((PsiElement)statement.getExpression());
                        break;
                    }
                    case IN_CONSTRUCTOR: {
                        LocalToFieldHandler.addInitializationToConstructors(this.myLocal, this.myField, enclosingConstructor, factory);
                        break;
                    }
                    case IN_SETUP_METHOD: {
                        LocalToFieldHandler.addInitializationToSetUp(this.myLocal, this.myField, factory);
                    }
                }
                if (enclosingConstructor != null && this.myInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
                    statement = LocalToFieldHandler.createAssignment(this.myLocal, this.myFieldName, factory);
                    declarationStatement.replace((PsiElement)statement);
                }
                if (rebindNeeded2) {
                    for (PsiReference reference : refs) {
                        if (reference == null) continue;
                        RefactoringUtil.replaceOccurenceWithFieldRef((PsiExpression)reference, this.myField, this.myDestinationClass);
                    }
                    ChangeContextUtil.decodeContextInfo((PsiElement)this.myDestinationClass, this.myDestinationClass, null);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        public PsiField getField() {
            return this.myField;
        }
    }
}

