/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class InlineSuperCallUsageInfo
extends FixableUsageInfo {
    private PsiCodeBlock myConstrBody;

    public InlineSuperCallUsageInfo(PsiMethodCallExpression methodCallExpression) {
        super((PsiElement)methodCallExpression);
    }

    public InlineSuperCallUsageInfo(PsiMethodCallExpression methodCallExpression, PsiCodeBlock constrBody) {
        super((PsiElement)methodCallExpression);
        this.myConstrBody = constrBody;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiReferenceExpression methodExpression;
        PsiMethod superConstructor;
        PsiElement element = this.getElement();
        if (element != null && this.myConstrBody != null) {
            assert (!element.isPhysical());
            PsiStatement statement = JavaPsiFacade.getElementFactory((Project)this.getProject()).createStatementFromText("super();", (PsiElement)this.myConstrBody);
            element = ((PsiExpressionStatement)this.myConstrBody.addBefore((PsiElement)statement, this.myConstrBody.getFirstBodyElement())).getExpression();
        }
        if (element instanceof PsiMethodCallExpression && (superConstructor = (PsiMethod)(methodExpression = ((PsiMethodCallExpression)element).getMethodExpression()).resolve()) != null) {
            PsiMethod methodCopy = JavaPsiFacade.getElementFactory((Project)this.getProject()).createMethod("toInline", (PsiType)PsiType.VOID);
            PsiCodeBlock constructorBody = superConstructor.getBody();
            if (constructorBody != null) {
                PsiCodeBlock methodBody2 = methodCopy.getBody();
                assert (methodBody2 != null);
                methodBody2.replace((PsiElement)constructorBody);
                methodCopy.getParameterList().replace((PsiElement)superConstructor.getParameterList());
                methodCopy.getThrowsList().replace((PsiElement)superConstructor.getThrowsList());
                methodExpression = (PsiReferenceExpression)methodExpression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)this.getProject()).createExpressionFromText(methodCopy.getName(), (PsiElement)methodExpression));
                PsiClass inliningClass = superConstructor.getContainingClass();
                assert (inliningClass != null);
                methodCopy = (PsiMethod)inliningClass.add((PsiElement)methodCopy);
                InlineMethodProcessor inlineMethodProcessor = new InlineMethodProcessor(this.getProject(), methodCopy, (PsiJavaCodeReferenceElement)methodExpression, null, true);
                inlineMethodProcessor.inlineMethodCall(methodExpression);
                methodCopy.delete();
            }
        }
    }

    public String getConflictMessage() {
        PsiMethodCallExpression methodCallExpression;
        PsiMethod superConstructor;
        MultiMap conflicts = new MultiMap();
        PsiElement element = this.getElement();
        if (element instanceof PsiMethodCallExpression && (superConstructor = (methodCallExpression = (PsiMethodCallExpression)element).resolveMethod()) != null) {
            InlineMethodProcessor.addInaccessibleMemberConflicts((PsiElement)superConstructor, new UsageInfo[]{new UsageInfo((PsiQualifiedReferenceElement)methodCallExpression.getMethodExpression())}, new ReferencedElementsCollector(){

                @Override
                protected void checkAddMember(@NotNull PsiMember member) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)superConstructor.getContainingClass(), (PsiElement)member, (boolean)false)) {
                        super.checkAddMember(member);
                    }
                }
            }, (MultiMap<PsiElement, String>)conflicts);
            if (InlineMethodProcessor.checkBadReturns(superConstructor) && !InlineUtil.allUsagesAreTailCalls(superConstructor)) {
                conflicts.putValue((Object)superConstructor, (Object)CommonRefactoringUtil.capitalize((String)(RefactoringBundle.message((String)"refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", (Object[])new Object[]{""}) + " of super constructor")));
            }
        }
        return conflicts.isEmpty() ? null : (String)conflicts.values().iterator().next();
    }
}

