/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class InlineMethodHelper {
    private static final Logger LOG = Logger.getInstance(InlineMethodHelper.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiManager myManager;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    private final PsiMethod myMethodCopy;
    @NotNull
    private final PsiElementFactory myFactory;
    @NotNull
    private final JavaCodeStyleManager myJavaCodeStyle;
    @NotNull
    private final PsiCallExpression myCall;
    @NotNull
    private final PsiExpressionList myCallArguments;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    InlineMethodHelper(@NotNull Project project, @NotNull PsiMethod method, @NotNull PsiMethod methodCopy, @NotNull PsiCallExpression call) {
        this.myProject = project;
        this.myManager = method.getManager();
        this.myMethod = method;
        this.myMethodCopy = methodCopy;
        this.myCall = call;
        this.myCallArguments = Objects.requireNonNull(call.getArgumentList());
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        this.myJavaCodeStyle = JavaCodeStyleManager.getInstance((Project)this.myProject);
        this.mySubstitutor = this.createSubstitutor();
    }

    @NotNull
    PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @NotNull
    private PsiSubstitutor createSubstitutor() {
        JavaResolveResult resolveResult = this.myCall.resolveMethodGenerics();
        if (this.myMethod.isPhysical()) {
            LOG.assertTrue(this.myManager.areElementsEquivalent(resolveResult.getElement(), (PsiElement)this.myMethod));
        }
        if (resolveResult.getSubstitutor() != PsiSubstitutor.EMPTY) {
            Iterator oldTypeParameters = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)this.myMethod);
            Iterator newTypeParameters = PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)this.myMethodCopy);
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            while (newTypeParameters.hasNext()) {
                PsiTypeParameter newTypeParameter = (PsiTypeParameter)newTypeParameters.next();
                PsiTypeParameter oldTypeParameter = (PsiTypeParameter)oldTypeParameters.next();
                substitutor = substitutor.put(newTypeParameter, resolveResult.getSubstitutor().substitute(oldTypeParameter));
            }
            return substitutor;
        }
        return PsiSubstitutor.EMPTY;
    }

    PsiLocalVariable @NotNull [] declareParameters() {
        PsiCodeBlock block = Objects.requireNonNull(this.myMethodCopy.getBody());
        int applicabilityLevel = PsiUtil.getApplicabilityLevel((PsiMethod)this.myMethod, (PsiSubstitutor)this.mySubstitutor, (PsiExpressionList)this.myCallArguments);
        PsiParameter[] parameters2 = this.myMethodCopy.getParameterList().getParameters();
        PsiLocalVariable[] parameterVars = new PsiLocalVariable[parameters2.length];
        for (int i = parameters2.length - 1; i >= 0; --i) {
            String defaultValue;
            String parameterName;
            PsiParameter parameter2 = parameters2[i];
            String name2 = parameterName = parameter2.getName();
            name2 = this.myJavaCodeStyle.variableNameToPropertyName(name2, VariableKind.PARAMETER);
            if (!(name2 = this.myJavaCodeStyle.propertyNameToVariableName(name2, VariableKind.LOCAL_VARIABLE)).equals(parameterName)) {
                name2 = this.myJavaCodeStyle.suggestUniqueVariableName(name2, block.getFirstChild(), true);
            }
            RefactoringUtil.renameVariableReferences((PsiVariable)parameter2, name2, (SearchScope)new LocalSearchScope((PsiElement)block), true);
            PsiType paramType = parameter2.getType();
            if (paramType instanceof PsiEllipsisType) {
                PsiEllipsisType ellipsisType = (PsiEllipsisType)paramType;
                paramType = this.mySubstitutor.substitute(ellipsisType.toArrayType());
                if (applicabilityLevel == 2) {
                    PsiType componentType = ((PsiArrayType)paramType).getComponentType();
                    defaultValue = "new " + ((PsiType)ObjectUtils.notNull((Object)TypeConversionUtil.erasure((PsiType)componentType), (Object)componentType)).getCanonicalText() + "[]{}";
                } else {
                    defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)paramType);
                }
            } else {
                defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)paramType);
            }
            PsiExpression initializer = this.myFactory.createExpressionFromText(defaultValue, null);
            PsiType varType = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.mySubstitutor.substitute(paramType));
            PsiDeclarationStatement declaration2 = this.myFactory.createVariableDeclarationStatement(name2, varType, initializer);
            declaration2 = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration2, null);
            parameterVars[i] = (PsiLocalVariable)declaration2.getDeclaredElements()[0];
            PsiUtil.setModifierProperty((PsiModifierListOwner)parameterVars[i], (String)"final", (boolean)parameter2.hasModifierProperty("final"));
        }
        return parameterVars;
    }

    void initializeParameters(PsiLocalVariable[] vars) {
        PsiExpression[] args = this.myCallArguments.getExpressions();
        if (vars.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                PsiArrayInitializerExpression arrayInitializer;
                int j = Math.min(i, vars.length - 1);
                PsiExpression initializer = vars[j].getInitializer();
                LOG.assertTrue(initializer != null);
                if (initializer instanceof PsiNewExpression && (arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer()) != null) {
                    arrayInitializer.add((PsiElement)args[i]);
                    continue;
                }
                initializer.replace((PsiElement)args[i]);
            }
        }
    }

    void inlineParameters(PsiLocalVariable[] parmVars) {
        PsiParameter[] parameters2 = this.myMethodCopy.getParameterList().getParameters();
        for (int i = 0; i < parmVars.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            boolean strictlyFinal = parameter2.hasModifierProperty("final") && this.isStrictlyFinal(parameter2);
            InlineUtil.tryInlineGeneratedLocal(parmVars[i], strictlyFinal);
        }
    }

    private boolean isStrictlyFinal(PsiParameter parameter2) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter2, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false)) {
            PsiElement refElement = reference.getElement();
            PsiElement anonymousClass = PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiAnonymousClass.class);
            if (anonymousClass == null || !PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)anonymousClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }
}

