/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.classMembers.ClassMembersUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractSuperClassViewDescriptor
extends UsageViewDescriptorAdapter {
    final PsiElement[] myElements;
    final List<PsiElement> myMembersToMakeWritable = new ArrayList<PsiElement>();

    public ExtractSuperClassViewDescriptor(PsiDirectory targetDirectory, PsiClass subclass, MemberInfo[] infos) {
        this.myElements = new PsiElement[infos.length + 2];
        this.myElements[0] = subclass;
        this.myElements[1] = targetDirectory;
        this.myMembersToMakeWritable.add((PsiElement)subclass);
        for (int i = 0; i < infos.length; ++i) {
            MemberInfo info = infos[i];
            this.myElements[i + 2] = info.getMember();
            if (!ClassMembersUtil.isProperMember(info)) continue;
            this.myMembersToMakeWritable.add(info.getMember());
        }
    }

    public PsiElement @NotNull [] getElements() {
        return this.myElements;
    }

    public List<PsiElement> getMembersToMakeWritable() {
        return this.myMembersToMakeWritable;
    }

    public String getProcessedElementsHeader() {
        return RefactoringBundle.message((String)"extract.superclass.elements.header");
    }
}

