/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberQualifierUtil {
    private static final Logger LOG = Logger.getInstance(MemberQualifierUtil.class);

    @Nullable
    public static String findObjectExpression(@NotNull PsiReferenceExpression reference, @NotNull PsiMember member, @NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        if (member.hasModifierProperty("static")) {
            return null;
        }
        PsiExpression qualifierExpression2 = reference.getQualifierExpression();
        if (qualifierExpression2 != null) {
            PsiType expressionType = qualifierExpression2.getType();
            return expressionType == null ? null : qualifierExpression2.getText();
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement resolveScope = resolveResult.getCurrentFileResolveScope();
        if (resolveScope instanceof PsiClass) {
            return MemberQualifierUtil.handleThisReference((PsiElement)reference, (PsiClass)resolveScope, outerClass, generatedCall, elementFactory);
        }
        return null;
    }

    @NotNull
    public static String handleThisReference(@NotNull PsiElement reference, @NotNull PsiClass referencedClass, @NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        String qualifiedName = referencedClass.getName();
        if (qualifiedName == null) {
            LOG.warn("Anonymous and local classes are not supported yet");
        } else if (!PsiTreeUtil.isAncestor((PsiElement)outerClass, (PsiElement)referencedClass, (boolean)false)) {
            PsiType accessibleType = PsiReflectionAccessUtil.nearestAccessibleType((PsiType)PsiTypesUtil.getClassType((PsiClass)referencedClass));
            PsiMethod generatedMethod = (PsiMethod)PsiTreeUtil.findFirstParent((PsiElement)reference, x -> x instanceof PsiMethod && "invoke".equals(((PsiMethod)x).getName()));
            if (generatedMethod == null) {
                LOG.warn("Could not find method 'invoke' in the generated class");
                return "this";
            }
            PsiParameterList parameterList = generatedMethod.getParameterList();
            String referredObjectName = "outerContext" + parameterList.getParametersCount();
            parameterList.add((PsiElement)elementFactory.createParameter(referredObjectName, accessibleType));
            generatedCall.getArgumentList().add((PsiElement)elementFactory.createExpressionFromText(qualifiedName + ".this", null));
            return referredObjectName;
        }
        return "this";
    }
}

