/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ExtractMethodObjectHandler.class);

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        ExtractMethodHandler.selectAndPass(project, editor, file, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodObjectHandler.invokeOnElements(project, editor, file, selectedValue);
            }
        });
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement[] elements = ExtractMethodHandler.getElements(file.getProject(), editor, file);
        return elements != null && elements.length > 0;
    }

    private static void invokeOnElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, PsiElement @NotNull [] elements) {
        if (elements.length == 0) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            return;
        }
        try {
            ExtractMethodObjectHandler.extractMethodObject(project, editor, new ExtractMethodObjectProcessor(project, editor, elements, ""));
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
        }
    }

    static void extractMethodObject(Project project, Editor editor, ExtractMethodObjectProcessor processor2) throws PrepareFailedException {
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor2.getExtractProcessor();
        if (!extractProcessor.prepare()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            ExtractMethodObjectHandler.extractMethodObject(project, editor, processor2, extractProcessor);
        }
    }

    public static void extractMethodObject(@NotNull Project project, Editor editor, @NotNull ExtractMethodObjectProcessor processor2, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        RangeMarker marker;
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            marker = editor.getDocument().createRangeMarker(offset, offset);
        } else {
            marker = null;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ExtractMethodObjectHandler.doRefactoring(project, editor, processor2, extractProcessor), "Extract Method Object", (Object)"Extract Method Object");
        if (editor != null) {
            editor.getCaretModel().moveToOffset(marker.getStartOffset());
            marker.dispose();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static void doRefactoring(@NotNull Project project, Editor editor, @NotNull ExtractMethodObjectProcessor processor2, @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> extractProcessor.doRefactoring());
                processor2.run();
                ApplicationManager.getApplication().runWriteAction(() -> processor2.runChangeSignature());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (processor2.isCreateInnerClass()) {
                processor2.moveUsedMethodsToInner();
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                if (editor != null) {
                    DuplicatesImpl.processDuplicates(extractProcessor, project, editor);
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiMethod method;
                if (processor2.isCreateInnerClass()) {
                    processor2.changeInstanceAccess(project);
                }
                LOG.assertTrue((method = processor2.getMethod()) != null);
                method.delete();
            });
        });
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        throw new UnsupportedOperationException();
    }
}

