/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractGeneratedClassUtil {
    private static final String GENERATED_CLASS_PACKAGE = "idea.debugger.rt";
    private static final Logger LOG = Logger.getInstance(ExtractGeneratedClassUtil.class);

    ExtractGeneratedClassUtil() {
    }

    static PsiClass extractGeneratedClass(@NotNull PsiClass generatedInnerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiElement anchor) {
        Project project = generatedInnerClass.getProject();
        PsiClass extractedClass = elementFactory.createClass("GeneratedEvaluationClass");
        for (PsiField psiField : generatedInnerClass.getAllFields()) {
            extractedClass.add((PsiElement)elementFactory.createFieldFromText(psiField.getText(), anchor));
        }
        for (PsiField psiField : generatedInnerClass.getMethods()) {
            extractedClass.add((PsiElement)elementFactory.createMethodFromText(psiField.getText(), anchor));
        }
        PsiJavaFile generatedFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(extractedClass.getName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)extractedClass.getContainingFile().getText());
        generatedFile.setPackageName(GENERATED_CLASS_PACKAGE);
        extractedClass = (PsiClass)PsiTreeUtil.findChildOfType((PsiElement)generatedFile, PsiClass.class);
        ExtractGeneratedClassUtil.copyStaticImports((PsiElement)generatedInnerClass, generatedFile, elementFactory);
        assert (extractedClass != null);
        PsiElement codeBlock = PsiTreeUtil.findFirstParent((PsiElement)anchor, (boolean)false, element -> element instanceof PsiCodeBlock);
        if (codeBlock == null) {
            codeBlock = anchor.getParent();
        }
        ExtractGeneratedClassUtil.addGeneratedClassInfo(codeBlock, generatedInnerClass, extractedClass);
        return extractedClass;
    }

    private static void copyStaticImports(@NotNull PsiElement from, @NotNull PsiJavaFile destFile, @NotNull PsiElementFactory elementFactory) {
        PsiImportList sourceImportList;
        PsiJavaFile fromFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)from, PsiJavaFile.class);
        if (fromFile != null && (sourceImportList = fromFile.getImportList()) != null) {
            PsiImportList destImportList = destFile.getImportList();
            LOG.assertTrue(destImportList != null, (Object)"import list of destination file should not be null");
            for (PsiImportStatementBase importStatement : sourceImportList.getAllImportStatements()) {
                if (!(importStatement instanceof PsiImportStaticStatement) || !ExtractGeneratedClassUtil.isPublic((PsiImportStaticStatement)importStatement)) continue;
                PsiElement importStatementCopy = ExtractGeneratedClassUtil.copy((PsiImportStaticStatement)importStatement, elementFactory);
                if (importStatementCopy != null) {
                    destImportList.add(importStatementCopy);
                    continue;
                }
                LOG.warn("Unable to copy static import statement: " + importStatement.getText());
            }
        }
    }

    @Nullable
    private static PsiElement copy(@NotNull PsiImportStaticStatement importStatement, @NotNull PsiElementFactory elementFactory) {
        PsiClass targetClass = importStatement.resolveTargetClass();
        String memberName = importStatement.getReferenceName();
        if (targetClass != null && memberName != null) {
            return elementFactory.createImportStaticStatement(targetClass, memberName);
        }
        return null;
    }

    private static boolean isPublic(@NotNull PsiImportStaticStatement staticImport) {
        PsiElement importedElement;
        PsiClass targetClass = staticImport.resolveTargetClass();
        if (targetClass != null && ExtractGeneratedClassUtil.isPublicClass(targetClass) && (importedElement = staticImport.resolve()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)importedElement).hasModifierProperty("public");
        }
        return false;
    }

    private static boolean isPublicClass(@NotNull PsiClass psiClass) {
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    private static void addGeneratedClassInfo(@NotNull PsiElement element, final @NotNull PsiClass generatedClass, final @NotNull PsiClass extractedClass) {
        generatedClass.putUserData(ExtractLightMethodObjectHandler.REFERENCED_TYPE, (Object)PsiTypesUtil.getClassType((PsiClass)extractedClass));
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                List methods;
                super.visitNewExpression(expression2);
                PsiMethod constructor = expression2.resolveConstructor();
                if (constructor != null && generatedClass.equals(constructor.getContainingClass()) && (methods = Arrays.stream(extractedClass.getConstructors()).filter(x -> this.isSameMethod((PsiMethod)x, constructor)).collect(Collectors.toList())).size() == 1) {
                    LOG.info("Replace constructor: " + constructor.getName());
                    constructor.putUserData(ExtractLightMethodObjectHandler.REFERENCE_METHOD, methods.get(0));
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                List methods;
                super.visitMethodCallExpression(expression2);
                PsiMethod method = expression2.resolveMethod();
                if (method != null && generatedClass.equals(method.getContainingClass()) && (methods = Arrays.stream(extractedClass.getMethods()).filter(x -> this.isSameMethod((PsiMethod)x, method)).collect(Collectors.toList())).size() == 1) {
                    LOG.info("Replace method: " + method.getName());
                    method.putUserData(ExtractLightMethodObjectHandler.REFERENCE_METHOD, methods.get(0));
                }
            }

            private boolean isSameMethod(@NotNull PsiMethod first, @NotNull PsiMethod second) {
                if (first.getName().equals(second.getName())) {
                    return first.getParameterList().getParametersCount() == second.getParameterList().getParametersCount();
                }
                return false;
            }
        });
    }
}

