/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.DuplicateNode;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.refactoring.extractMethod.preview.PatternNode;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class PreviewTreeModel
extends DefaultTreeModel {
    private final DefaultMutableTreeNode myDuplicatesGroup;
    private final DefaultMutableTreeNode myMethodGroup;
    private final PatternNode myPatternNode;
    private boolean myValid;

    PreviewTreeModel(@NotNull ExtractMethodProcessor processor2) {
        super(new DefaultMutableTreeNode(""));
        this.setValidImpl(true);
        DefaultMutableTreeNode root = this.getRoot();
        this.myMethodGroup = new DefaultMutableTreeNode(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.group.method", (Object[])new Object[0]));
        root.add(this.myMethodGroup);
        PsiMethod emptyMethod = processor2.generateEmptyMethod(processor2.getMethodName(), (PsiElement)processor2.getTargetClass());
        this.myMethodGroup.add(new MethodNode(emptyMethod));
        DefaultMutableTreeNode originalGroup = new DefaultMutableTreeNode(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.group.original", (Object[])new Object[0]));
        root.add(originalGroup);
        PsiElement[] elements = processor2.getElements();
        this.myPatternNode = new PatternNode(elements);
        originalGroup.add(this.myPatternNode);
        List<Match> duplicates = processor2.getAnyDuplicates();
        if (!ContainerUtil.isEmpty(duplicates)) {
            this.myDuplicatesGroup = new DefaultMutableTreeNode(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.group.duplicates", (Object[])new Object[0]));
            root.add(this.myDuplicatesGroup);
            for (Match duplicate : duplicates) {
                this.myDuplicatesGroup.add(new DuplicateNode(duplicate));
            }
        } else {
            this.myDuplicatesGroup = null;
        }
    }

    @Override
    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    @NotNull
    MethodNode updateMethod(PsiMethod method) {
        this.myMethodGroup.removeAllChildren();
        MethodNode methodNode = new MethodNode(method);
        this.myMethodGroup.add(methodNode);
        this.reload(this.myMethodGroup);
        return methodNode;
    }

    @NotNull
    public List<DuplicateNode> getEnabledDuplicates() {
        if (this.myDuplicatesGroup != null && this.myDuplicatesGroup.getChildCount() != 0) {
            ArrayList<DuplicateNode> duplicates = new ArrayList<DuplicateNode>();
            for (int i = 0; i < this.myDuplicatesGroup.getChildCount(); ++i) {
                DuplicateNode duplicateNode;
                TreeNode node = this.myDuplicatesGroup.getChildAt(i);
                if (!(node instanceof DuplicateNode) || (duplicateNode = (DuplicateNode)node).isExcluded() || !duplicateNode.isValid()) continue;
                duplicates.add(duplicateNode);
            }
            return duplicates;
        }
        return Collections.emptyList();
    }

    @NotNull
    public List<DuplicateNode> getAllDuplicates() {
        if (this.myDuplicatesGroup != null && this.myDuplicatesGroup.getChildCount() != 0) {
            ArrayList<DuplicateNode> duplicates = new ArrayList<DuplicateNode>();
            for (int i = 0; i < this.myDuplicatesGroup.getChildCount(); ++i) {
                TreeNode node = this.myDuplicatesGroup.getChildAt(i);
                if (!(node instanceof DuplicateNode)) continue;
                duplicates.add((DuplicateNode)node);
            }
            return duplicates;
        }
        return Collections.emptyList();
    }

    @NotNull
    public PatternNode getPatternNode() {
        return this.myPatternNode;
    }

    public synchronized boolean isValid() {
        return this.myValid;
    }

    private synchronized void setValidImpl(boolean valid) {
        this.myValid = valid;
    }

    public void setValid(boolean valid) {
        this.setValidImpl(valid);
        this.setValid(this.getRoot(), valid);
    }

    private void setValid(TreeNode node, boolean valid) {
        if (node instanceof FragmentNode) {
            ((FragmentNode)node).setValid(valid);
            this.reload(node);
        }
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.setValid(node.getChildAt(i), valid);
            }
        }
    }
}

