/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.extractMethod.preview.ElementsRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractableFragment {
    private final SmartPsiElementPointer<PsiElement> myStart;
    private final SmartPsiElementPointer<PsiElement> myEnd;

    ExtractableFragment(@NotNull PsiElement start, @NotNull PsiElement end) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)start.getProject());
        this.myStart = smartPointerManager.createSmartPsiElementPointer(start);
        this.myEnd = start != end ? smartPointerManager.createSmartPsiElementPointer(end) : this.myStart;
    }

    ExtractableFragment(PsiElement @NotNull [] elements) {
        if (elements.length == 0) {
            this.myStart = null;
            this.myEnd = null;
            return;
        }
        PsiElement start = elements[0];
        PsiElement end = elements[elements.length - 1];
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)start.getProject());
        this.myStart = smartPointerManager.createSmartPsiElementPointer(start);
        this.myEnd = start != end ? smartPointerManager.createSmartPsiElementPointer(end) : this.myStart;
    }

    @Nullable
    public Navigatable getNavigatable() {
        PsiElement start = this.myStart != null ? this.myStart.getElement() : null;
        return start instanceof Navigatable ? (Navigatable)start : null;
    }

    @Nullable
    public ElementsRange getElementsRange() {
        if (this.myStart == null || this.myEnd == null) {
            return null;
        }
        PsiElement start = this.myStart.getElement();
        if (this.myStart == this.myEnd) {
            return start != null ? new ElementsRange(start, start) : null;
        }
        PsiElement end = this.myEnd.getElement();
        if (start == null || end == null) {
            return null;
        }
        return new ElementsRange(start, end);
    }

    @Nullable
    public TextRange getTextRange() {
        ElementsRange elementsRange = this.getElementsRange();
        return elementsRange != null ? elementsRange.getTextRange() : null;
    }
}

