/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputVariables {
    private final List<VariableData> myInputVariables;
    private final List<? extends PsiVariable> myInitialParameters;
    private final Project myProject;
    private final LocalSearchScope myScope;
    private final ParametersFolder myFolding;
    private boolean myFoldingAvailable;
    @NotNull
    private final Set<? extends PsiField> myUsedInstanceFields;
    private boolean myPassFields;

    public InputVariables(@NotNull List<? extends PsiVariable> inputVariables, @NotNull Project project, @NotNull LocalSearchScope scope, boolean foldingAvailable, @NotNull Set<? extends PsiField> usedInstanceFields) {
        this.myInitialParameters = inputVariables;
        this.myProject = project;
        this.myScope = scope;
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding = new ParametersFolder();
        this.myUsedInstanceFields = usedInstanceFields;
        this.myInputVariables = this.wrapInputVariables(inputVariables);
    }

    private InputVariables(@NotNull List<? extends VariableData> inputVariableData, @NotNull Project project, @NotNull LocalSearchScope scope, boolean foldingAvailable, @NotNull ParametersFolder folding, @NotNull List<? extends PsiVariable> initialParameters, @NotNull Set<? extends PsiField> usedInstanceFields) {
        this.myInitialParameters = initialParameters;
        this.myProject = project;
        this.myScope = scope;
        this.myFoldingAvailable = foldingAvailable;
        this.myInputVariables = new ArrayList<VariableData>(inputVariableData);
        this.myFolding = folding;
        this.myUsedInstanceFields = usedInstanceFields;
    }

    public boolean isFoldable() {
        return this.myFolding.isFoldable();
    }

    public void setPassFields(boolean passFields) {
        if (!this.hasInstanceFields()) {
            return;
        }
        this.myPassFields = passFields;
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public boolean isPassFields() {
        return this.myPassFields;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<VariableData> wrapInputVariables(@NotNull List<? extends PsiVariable> inputVariables) {
        VariableData data;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        ArrayList<VariableData> inputData = new ArrayList<VariableData>(inputVariables.size());
        for (PsiVariable psiVariable : inputVariables) {
            String defaultName = this.getParameterName(psiVariable);
            String name2 = nameGenerator.generateUniqueName(defaultName);
            PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)psiVariable.getType());
            HashMap<PsiCodeBlock, PsiType> casts = new HashMap<PsiCodeBlock, PsiType>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiVariable, (SearchScope)this.myScope)) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class);
                if (parent instanceof PsiTypeCastExpression) {
                    PsiType currentType = (PsiType)casts.get(block);
                    PsiType castType = ((PsiTypeCastExpression)parent).getType();
                    casts.put(block, casts.containsKey(block) && currentType == null ? null : InputVariables.getBroaderType(currentType, castType));
                    continue;
                }
                casts.put(block, null);
            }
            if (!casts.containsValue(null)) {
                PsiType psiType;
                PsiType currentType = null;
                Iterator iterator = casts.values().iterator();
                while (iterator.hasNext() && (currentType = InputVariables.getBroaderType(currentType, psiType = (PsiType)iterator.next())) != null) {
                }
                if (currentType != null && (currentType = InputVariables.checkTopLevelInstanceOf(currentType, this.myScope)) != null) {
                    type2 = currentType;
                }
            }
            VariableData data2 = new VariableData(psiVariable, type2);
            data2.name = name2;
            data2.passAsParameter = true;
            inputData.add(data2);
            if (!this.myFoldingAvailable) continue;
            this.myFolding.isParameterFoldable(data2, this.myScope, inputVariables, nameGenerator, defaultName);
        }
        if (this.myFoldingAvailable) {
            void var5_7;
            HashSet<VariableData> toDelete = new HashSet<VariableData>();
            int n = inputData.size() - 1;
            while (var5_7 >= 0) {
                data = (VariableData)((Object)inputData.get((int)var5_7));
                if (this.myFolding.isParameterSafeToDelete(data, this.myScope)) {
                    toDelete.add(data);
                }
                --var5_7;
            }
            inputData.removeAll(toDelete);
        }
        if (this.myPassFields) {
            for (PsiField psiField : this.myUsedInstanceFields) {
                data = new VariableData((PsiVariable)psiField, psiField.getType());
                data.name = nameGenerator.generateUniqueName(this.getParameterName((PsiVariable)psiField));
                data.passAsParameter = true;
                inputData.add(data);
            }
        }
        return inputData;
    }

    @NotNull
    private String getParameterName(@NotNull PsiVariable var) {
        if (var instanceof PsiParameter) {
            return ((PsiParameter)var).getName();
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        VariableKind kind2 = codeStyleManager.getVariableKind(var);
        String name2 = codeStyleManager.variableNameToPropertyName(var.getName(), kind2);
        name2 = codeStyleManager.propertyNameToVariableName(name2, VariableKind.PARAMETER);
        return name2;
    }

    @Nullable
    private static PsiType checkTopLevelInstanceOf(PsiType currentType, @NotNull LocalSearchScope localSearchScope) {
        PsiExpression condition2;
        PsiElement[] scope = localSearchScope.getScope();
        if (scope.length == 1 && scope[0] instanceof PsiIfStatement && (condition2 = ((PsiIfStatement)scope[0]).getCondition()) != null) {
            PsiInstanceOfExpression[] expressions2 = (PsiInstanceOfExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)condition2, PsiInstanceOfExpression.class);
            if (expressions2 != null) {
                for (PsiInstanceOfExpression instanceOfExpression : expressions2) {
                    if (!InputVariables.isOfCurrentType(instanceOfExpression, currentType)) continue;
                    return null;
                }
            } else if (condition2 instanceof PsiInstanceOfExpression && InputVariables.isOfCurrentType((PsiInstanceOfExpression)condition2, currentType)) {
                return null;
            }
        }
        return currentType;
    }

    private static boolean isOfCurrentType(@NotNull PsiInstanceOfExpression expr2, PsiType currentType) {
        PsiTypeElement checkType = expr2.getCheckType();
        return checkType != null && checkType.getType().equals(currentType);
    }

    @Nullable
    private static PsiType getBroaderType(PsiType currentType, PsiType castType) {
        if (currentType != null) {
            if (castType != null) {
                if (TypeConversionUtil.isAssignable((PsiType)castType, (PsiType)currentType)) {
                    return castType;
                }
                if (!TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)castType)) {
                    for (PsiType superType : castType.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)currentType)) continue;
                        return superType;
                    }
                    return null;
                }
            }
        } else {
            return castType;
        }
        return currentType;
    }

    @NotNull
    public List<VariableData> getInputVariables() {
        return this.myInputVariables;
    }

    public PsiExpression replaceWrappedReferences(PsiElement @NotNull [] elements, PsiExpression expression2) {
        if (!this.myFoldingAvailable) {
            return expression2;
        }
        boolean update2 = elements[0] == expression2;
        this.myFolding.foldParameterUsagesInBody(this.myInputVariables, elements, (SearchScope)this.myScope);
        return update2 ? (PsiExpression)elements[0] : expression2;
    }

    public boolean toDeclareInsideBody(@NotNull PsiVariable variable) {
        ArrayList<VariableData> knownVars = new ArrayList<VariableData>(this.myInputVariables);
        for (VariableData data : knownVars) {
            if (!data.variable.equals(variable)) continue;
            return false;
        }
        return !this.myFolding.wasExcluded(variable);
    }

    public boolean contains(@NotNull PsiVariable variable) {
        for (VariableData data : this.myInputVariables) {
            if (!data.variable.equals(variable)) continue;
            return true;
        }
        return false;
    }

    public void removeParametersUsedInExitsOnly(@NotNull PsiElement codeFragment, @NotNull Collection<? extends PsiStatement> exitStatements, @NotNull ControlFlow controlFlow, int startOffset, int endOffset) {
        LocalSearchScope scope = new LocalSearchScope(codeFragment);
        Iterator<VariableData> iterator = this.myInputVariables.iterator();
        block0: while (iterator.hasNext()) {
            VariableData data = iterator.next();
            for (PsiReference ref : ReferencesSearch.search((PsiElement)data.variable, (SearchScope)scope)) {
                PsiElement element = ref.getElement();
                int elementOffset = controlFlow.getStartOffset(element);
                if (elementOffset < startOffset || elementOffset > endOffset || InputVariables.isInExitStatements(element, exitStatements)) continue;
                continue block0;
            }
            iterator.remove();
        }
    }

    private static boolean isInExitStatements(@NotNull PsiElement element, @NotNull Collection<? extends PsiStatement> exitStatements) {
        for (PsiStatement psiStatement : exitStatements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiStatement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public InputVariables copy() {
        return new InputVariables(this.myInputVariables, this.myProject, this.myScope, this.myFoldingAvailable, this.myFolding, this.myInitialParameters, Collections.emptySet());
    }

    @NotNull
    public InputVariables copyWithoutFolding() {
        return new InputVariables(this.myInitialParameters, this.myProject, this.myScope, false, Collections.emptySet());
    }

    public void appendCallArguments(@NotNull VariableData data, @NotNull StringBuilder buffer) {
        if (this.myFoldingAvailable) {
            buffer.append(this.myFolding.getGeneratedCallArgument(data));
        } else {
            if (!TypeConversionUtil.isAssignable((PsiType)data.type, (PsiType)data.variable.getType())) {
                buffer.append("(").append(data.type.getCanonicalText()).append(")");
            }
            buffer.append(data.variable.getName());
        }
    }

    @NotNull
    public ParametersFolder getFolding() {
        return this.myFolding;
    }

    public void setFoldingAvailable(boolean foldingAvailable) {
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding.clear();
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public void annotateWithParameter(@NotNull PsiJavaCodeReferenceElement reference) {
        if (this.myInputVariables.isEmpty()) {
            return;
        }
        PsiElement element = reference.resolve();
        for (VariableData data : this.myInputVariables) {
            PsiMethod psiMethod;
            int idx;
            if (!data.variable.equals(element)) continue;
            PsiType type2 = data.variable.getType();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (idx = ArrayUtil.find((Object[])methodCallExpression.getArgumentList().getExpressions(), (Object)reference)) > -1 && (psiMethod = methodCallExpression.resolveMethod()) != null) {
                PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                if (idx >= parameters2.length && (idx = parameters2.length - 1) >= 0) {
                    type2 = parameters2[idx].getType();
                }
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).getComponentType();
                }
            }
            if (this.myFoldingAvailable && this.myFolding.annotateWithParameter(data, (PsiElement)reference)) continue;
            reference.putUserData(DuplicatesFinder.PARAMETER, (Object)new DuplicatesFinder.Parameter(data.variable, type2));
        }
    }

    public void foldExtractedParameter(@NotNull PsiVariable extractedParameter, @NotNull PsiExpression value2) {
        this.myFoldingAvailable = true;
        this.myFolding.putCallArgument(extractedParameter, value2);
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFolding.isFoldingSelectedByDefault();
    }

    public boolean hasInstanceFields() {
        return !this.myUsedInstanceFields.isEmpty();
    }
}

