/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class OptionalChainCallExtractor
implements ChainCallExtractor {
    private static final CallMatcher NEXT_CALL = CallMatcher.instanceCall("java.util.Optional", "ifPresent", "map", "flatMap").parameterCount(1);

    @Override
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, PsiExpression expression2, PsiType expressionType) {
        if (expressionType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        return qualifier != null && NEXT_CALL.test(call);
    }

    @Override
    public String getMethodName(PsiVariable variable, PsiExpression expression2, PsiType expressionType) {
        return "map";
    }
}

