/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAnonymousToInnerHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (element instanceof PsiAnonymousClass) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (element instanceof PsiAnonymousClass && element.getParent() instanceof PsiNewExpression) {
            new AnonymousToInnerHandler().invoke(project, editor, (PsiAnonymousClass)element);
            return true;
        }
        return false;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        return language instanceof JvmLanguage;
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        return JavaRefactoringBundle.message((String)"convert.anonymous.to.inner.action.name", (Object[])new Object[0]);
    }
}

