/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.IntroduceFunctionalParameterAction;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class IntroduceFunctionalParameterHandler
extends IntroduceParameterHandler {
    @Override
    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (dataContext != null) {
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file != null && editor != null && !this.introduceStrategy(project, editor, file, elements)) {
                IntroduceFunctionalParameterHandler.showErrorMessage(project, editor);
            }
        }
    }

    @Override
    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        ExtractMethodHandler.selectAndPass(project, editor, file, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] elements) {
                if (!IntroduceFunctionalParameterHandler.this.introduceStrategy(project, editor, file, elements)) {
                    IntroduceFunctionalParameterHandler.showErrorMessage(project, editor);
                }
            }
        });
    }

    private static void showErrorMessage(@NotNull Project project, Editor editor) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceFunctionalParameterAction.getRefactoringName()}));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)IntroduceFunctionalParameterAction.getRefactoringName(), (String)"refactoring.introduceParameter");
    }
}

