/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandlerBase
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(IntroduceHandlerBase.class);

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement[] elements = ExtractMethodHandler.getElements(file.getProject(), editor, file);
        if (elements != null && elements.length > 0) {
            return true;
        }
        return this.acceptLocalVariable() && PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiLocalVariable.class) != null;
    }

    protected boolean acceptLocalVariable() {
        return true;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Object editor;
        LOG.assertTrue(elements.length >= 1 && elements[0] instanceof PsiExpression, (Object)"incorrect invoke() parameters");
        PsiElement tempExpr = elements[0];
        if (dataContext != null) {
            PsiFile cachedPsiFile;
            Editor editorFromDC = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            PsiFile psiFile = cachedPsiFile = editorFromDC != null ? PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editorFromDC.getDocument()) : null;
            editor = PsiTreeUtil.isAncestor((PsiElement)cachedPsiFile, (PsiElement)tempExpr, (boolean)false) ? editorFromDC : null;
        } else {
            editor = null;
        }
        this.invoke(project, tempExpr, (Editor)editor);
    }

    public void invoke(@NotNull Project project, PsiElement element, @Nullable Editor editor) {
        if (element instanceof PsiExpression) {
            this.invokeImpl(project, (PsiExpression)element, editor);
        } else if (element instanceof PsiLocalVariable) {
            this.invokeImpl(project, (PsiLocalVariable)element, editor);
        } else {
            LOG.error("elements[0] should be PsiExpression or PsiLocalVariable");
        }
    }

    protected abstract boolean invokeImpl(Project var1, PsiExpression var2, @Nullable Editor var3);

    protected abstract boolean invokeImpl(Project var1, PsiLocalVariable var2, @Nullable Editor var3);

    public abstract AbstractInplaceIntroducer getInplaceIntroducer();
}

