/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceParameterListImpl
extends CompositePsiElement
implements PsiReferenceParameterList {
    private static final Logger LOG = Logger.getInstance(PsiReferenceParameterListImpl.class);
    private static final TokenSet TYPE_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.TYPE});

    public PsiReferenceParameterListImpl() {
        super(JavaElementType.REFERENCE_PARAMETER_LIST);
    }

    public PsiTypeElement @NotNull [] getTypeParameterElements() {
        return (PsiTypeElement[])this.getChildrenAsPsiElements(JavaElementType.TYPE, PsiTypeElement.ARRAY_FACTORY);
    }

    public PsiType @NotNull [] getTypeArguments() {
        return PsiImplUtil.typesByReferenceParameterList(this);
    }

    public int getChildRole(@NotNull ASTNode child) {
        IElementType i = child.getElementType();
        if (i == JavaElementType.TYPE) {
            return 120;
        }
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LT) {
            return 121;
        }
        if (i == JavaTokenType.GT) {
            return 122;
        }
        return 0;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 121: {
                if (this.getFirstChildNode() != null && this.getFirstChildNode().getElementType() == JavaTokenType.LT) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 122: 
        }
        if (this.getLastChildNode() != null && this.getLastChildNode().getElementType() == JavaTokenType.GT) {
            return this.getLastChildNode();
        }
        return null;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first == last && first.getElementType() == JavaElementType.TYPE && this.getLastChildNode() != null && this.getLastChildNode().getElementType() == TokenType.ERROR_ELEMENT) {
            super.deleteChildInternal((ASTNode)this.getLastChildNode());
        }
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
        if (this.getFirstChildNode() == null || this.getFirstChildNode().getElementType() != JavaTokenType.LT) {
            LeafElement lt = Factory.createSingleLeafElement((IElementType)JavaTokenType.LT, (CharSequence)"<", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
            super.addInternal((TreeElement)lt, (ASTNode)lt, (ASTNode)this.getFirstChildNode(), Boolean.TRUE);
        }
        if (this.getLastChildNode() == null || this.getLastChildNode().getElementType() != JavaTokenType.GT) {
            LeafElement gt = Factory.createSingleLeafElement((IElementType)JavaTokenType.GT, (CharSequence)">", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
            super.addInternal((TreeElement)gt, (ASTNode)gt, (ASTNode)this.getLastChildNode(), Boolean.FALSE);
        }
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(122);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(121);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (first == last && first.getElementType() == JavaElementType.TYPE) {
            JavaSourceUtil.addSeparatingComma((CompositeElement)this, (ASTNode)first, TYPE_SET);
        }
        return firstAdded;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child.getElementType() == JavaElementType.TYPE) {
            JavaSourceUtil.deleteSeparatingComma((CompositeElement)this, child);
        }
        super.deleteChildInternal(child);
        if (this.getTypeParameterElements().length == 0) {
            ASTNode gt;
            ASTNode lt = this.findChildByRole(121);
            if (lt != null) {
                this.deleteChildInternal(lt);
            }
            if ((gt = this.findChildByRole(122)) != null) {
                this.deleteChildInternal(gt);
            }
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceParameterList((PsiReferenceParameterList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiReferenceParameterList";
    }
}

