/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiPackageStatementImpl
extends CompositePsiElement
implements PsiPackageStatement {
    private static final Logger LOG = Logger.getInstance(PsiPackageStatementImpl.class);

    public PsiPackageStatementImpl() {
        super(JavaElementType.PACKAGE_STATEMENT);
    }

    public PsiJavaCodeReferenceElement getPackageReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(103);
    }

    public String getPackageName() {
        PsiJavaCodeReferenceElement ref = this.getPackageReference();
        return ref == null ? null : JavaSourceUtil.getReferenceText(ref);
    }

    public PsiModifierList getAnnotationList() {
        return (PsiModifierList)this.findChildByRoleAsPsiElement(8);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 102: {
                return this.findChildByType(JavaTokenType.PACKAGE_KEYWORD);
            }
            case 103: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 22: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.SEMICOLON);
            }
            case 8: 
        }
        return this.findChildByType(JavaElementType.MODIFIER_LIST);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.PACKAGE_KEYWORD) {
            return 102;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 103;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        if (i == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackageStatement((PsiPackageStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPackageStatement:" + this.getPackageName();
    }
}

