/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiIfStatementImpl
extends CompositePsiElement
implements PsiIfStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiIfStatementImpl.class);

    public PsiIfStatementImpl() {
        super(IF_STATEMENT);
    }

    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode elseKeyword;
        if (child == this.getThenBranch()) {
            this.replaceChildInternal(child, (TreeElement)JavaPsiFacade.getElementFactory((Project)this.getProject()).createStatementFromText("{}", null));
            return;
        }
        if (child == this.getElseBranch() && (elseKeyword = this.findChildByRole(31)) != null) {
            super.deleteChildInternal(elseKeyword);
        }
        super.deleteChildInternal(child);
    }

    public PsiStatement getThenBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(33);
    }

    public PsiStatement getElseBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(34);
    }

    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    public PsiKeyword getElseElement() {
        return (PsiKeyword)this.findChildByRoleAsPsiElement(31);
    }

    public void setElseBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiKeyword elseElement;
        PsiStatement elseBranch = this.getElseBranch();
        if (elseBranch != null) {
            elseBranch.delete();
        }
        if ((elseElement = this.getElseElement()) != null) {
            elseElement.delete();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiIfStatement ifStatement = (PsiIfStatement)elementFactory.createStatementFromText("if (true) {} else {}", (PsiElement)this);
        ifStatement.getElseBranch().replace((PsiElement)statement);
        this.addRange((PsiElement)ifStatement.getElseElement(), ifStatement.getLastChild());
    }

    public void setThenBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiStatement thenBranch;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        ASTNode keyword = this.findChildByRole(30);
        LOG.assertTrue(keyword != null);
        PsiIfStatement ifStatementPattern = (PsiIfStatement)elementFactory.createStatementFromText("if (){}", (PsiElement)this);
        if (this.getLParenth() == null) {
            this.addAfter((PsiElement)ifStatementPattern.getLParenth(), keyword.getPsi());
        }
        if (this.getRParenth() == null) {
            PsiJavaToken anchor = this.getCondition() == null ? this.getLParenth() : this.getCondition();
            this.addAfter((PsiElement)ifStatementPattern.getRParenth(), (PsiElement)anchor);
        }
        if ((thenBranch = this.getThenBranch()) == null) {
            this.addAfter((PsiElement)statement, (PsiElement)this.getRParenth());
        } else {
            thenBranch.replace((PsiElement)statement);
        }
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 30: {
                return this.findChildByType(IF_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 33: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 31: {
                return this.findChildByType(ELSE_KEYWORD);
            }
            case 34: 
        }
        ASTNode elseKeyword = this.findChildByRole(31);
        if (elseKeyword == null) {
            return null;
        }
        for (ASTNode child = elseKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == IF_KEYWORD) {
            return 30;
        }
        if (i == ELSE_KEYWORD) {
            return 31;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            if (this.findChildByRoleAsPsiElement(33) == child) {
                return 33;
            }
            return 34;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitIfStatement((PsiIfStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint elementClassHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        PsiExpression condition2 = this.getCondition();
        if (condition2 != null) {
            PsiStatement thenBranch = this.getThenBranch();
            PsiStatement elseBranch = this.getElseBranch();
            if (lastParent == null) {
                if (state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_NONE) {
                    return true;
                }
                PsiScopeProcessor conditionProcessor = state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_BOTH ? processor2 : (element, s) -> {
                    ControlFlow flow;
                    LOG.assertTrue(element instanceof PsiPatternVariable);
                    NameHint hint = (NameHint)processor2.getHint(NameHint.KEY);
                    if (hint != null && !((PsiPatternVariable)element).getName().equals(hint.getName(s))) {
                        return true;
                    }
                    try {
                        flow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow((PsiElement)this, new LocalsControlFlowPolicy((PsiElement)this), false, false);
                    }
                    catch (AnalysisCanceledException e) {
                        return true;
                    }
                    boolean thenCompletesNormally = PsiIfStatementImpl.canCompleteNormally(thenBranch, flow);
                    boolean elseCompletesNormally = PsiIfStatementImpl.canCompleteNormally(elseBranch, flow);
                    if (thenCompletesNormally == elseCompletesNormally || PatternResolveState.fromBoolean(thenCompletesNormally) != PatternResolveState.stateAtParent((PsiPatternVariable)element, condition2)) {
                        return true;
                    }
                    return processor2.execute(element, s);
                };
                return condition2.processDeclarations(conditionProcessor, PatternResolveState.WHEN_BOTH.putInto(state), null, place);
            }
            if (lastParent == thenBranch) {
                return condition2.processDeclarations(processor2, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
            }
            if (lastParent == elseBranch) {
                return condition2.processDeclarations(processor2, PatternResolveState.WHEN_FALSE.putInto(state), null, place);
            }
        }
        return true;
    }

    private static boolean canCompleteNormally(PsiStatement branch, ControlFlow flow) {
        if (branch == null) {
            return true;
        }
        int startOffset = flow.getStartOffset((PsiElement)branch);
        int endOffset = flow.getEndOffset((PsiElement)branch);
        return startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(flow, startOffset, endOffset);
    }

    public String toString() {
        return "PsiIfStatement";
    }
}

