/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiLoopStatementImpl;
import com.intellij.psi.impl.source.tree.java.PsiWhileStatementImpl;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiForStatementImpl
extends PsiLoopStatementImpl
implements PsiForStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiForStatementImpl.class);

    public PsiForStatementImpl() {
        super(FOR_STATEMENT);
    }

    public PsiStatement getInitialization() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(39);
    }

    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    public PsiStatement getUpdate() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(40);
    }

    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    public ASTNode findChildByRole(int role) {
        ASTNode rparenth;
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 37: {
                return this.findChildByType(FOR_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 39: {
                ASTNode paren;
                ASTNode initialization = PsiImplUtil.findStatementChild(this);
                for (ASTNode child = paren = this.findChildByRole(24); child != null; child = child.getTreeNext()) {
                    if (child == initialization) {
                        return initialization;
                    }
                    if (child.getElementType() != RPARENTH) continue;
                    return null;
                }
                return null;
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 41: {
                return this.findChildByType(SEMICOLON);
            }
            case 40: {
                ASTNode semicolon;
                for (ASTNode child = semicolon = this.findChildByRole(41); child != null; child = child.getTreeNext()) {
                    if (child.getPsi() instanceof PsiStatement) {
                        return child;
                    }
                    if (child.getElementType() == RPARENTH) break;
                }
                return null;
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        for (ASTNode child = rparenth = this.findChildByRole(25); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == FOR_KEYWORD) {
            return 37;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == SEMICOLON) {
            return 41;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            int role = this.getChildRole(child, 39);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 40);
            if (role != 0) {
                return role;
            }
            return 38;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitForStatement((PsiForStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiForStatement";
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (this.getChildRole(child) == 39) {
            this.replaceChildInternal(child, (TreeElement)JavaPsiFacade.getElementFactory((Project)this.getProject()).createStatementFromText(";", null));
        } else {
            super.deleteChildInternal(child);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint elementClassHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        if (lastParent == null) {
            return PsiWhileStatementImpl.processDeclarationsInLoopCondition(processor2, state, place, (PsiConditionalLoopStatement)this);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        PsiStatement initialization = this.getInitialization();
        if (initialization != null && lastParent != initialization && !initialization.processDeclarations(processor2, state, null, place)) {
            return false;
        }
        PsiExpression condition2 = this.getCondition();
        if (condition2 != null && (lastParent == this.getBody() || lastParent == this.getUpdate())) {
            return condition2.processDeclarations(processor2, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
        }
        return true;
    }
}

