/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiCompositeModifierList
extends LightModifierList {
    private final List<? extends PsiModifierList> mySublists;

    public PsiCompositeModifierList(PsiManager manager, List<? extends PsiModifierList> sublists) {
        super(manager);
        this.mySublists = sublists;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        ArrayList annotations = new ArrayList();
        for (PsiModifierList psiModifierList : this.mySublists) {
            ContainerUtil.addAll(annotations, (Object[])psiModifierList.getAnnotations());
        }
        return annotations.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        for (PsiModifierList psiModifierList : this.mySublists) {
            PsiAnnotation annotation = psiModifierList.findAnnotation(qualifiedName);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        for (PsiModifierList psiModifierList : this.mySublists) {
            if (!psiModifierList.hasModifierProperty(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name2) {
        for (PsiModifierList psiModifierList : this.mySublists) {
            if (!psiModifierList.hasExplicitModifier(name2)) continue;
            return true;
        }
        return false;
    }
}

