/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCodeBlockImpl
extends LazyParseablePsiElement
implements PsiCodeBlock {
    private static final Logger LOG = Logger.getInstance(PsiCodeBlockImpl.class);
    private volatile Set<String> myVariablesSet;
    private volatile Set<String> myClassesSet;
    private volatile boolean myConflict;

    public PsiCodeBlockImpl(CharSequence text2) {
        super((IElementType)JavaElementType.CODE_BLOCK, text2);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myVariablesSet = null;
        this.myClassesSet = null;
        this.myConflict = false;
    }

    public PsiStatement @NotNull [] getStatements() {
        return PsiImplUtil.getChildStatements((CompositeElement)this);
    }

    public int getStatementCount() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (TreeElement child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return false;
        }
        return true;
    }

    public PsiElement getFirstBodyElement() {
        PsiJavaToken lBrace = this.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement nextSibling = lBrace.getNextSibling();
        return nextSibling == this.getRBrace() ? null : nextSibling;
    }

    public PsiElement getLastBodyElement() {
        PsiJavaToken rBrace = this.getRBrace();
        if (rBrace != null) {
            PsiElement prevSibling = rBrace.getPrevSibling();
            return prevSibling == this.getLBrace() ? null : prevSibling;
        }
        return this.getLastChild();
    }

    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(18);
    }

    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(19);
    }

    @Nullable
    private Couple<Set<String>> buildMaps() {
        THashSet set1 = this.myClassesSet;
        THashSet set2 = this.myVariablesSet;
        boolean wasConflict = this.myConflict;
        if (set1 == null || set2 == null) {
            THashSet localsSet = new THashSet();
            THashSet classesSet = new THashSet();
            Ref conflict = new Ref((Object)Boolean.FALSE);
            PsiScopesUtil.walkChildrenScopes((PsiElement)this, new PsiScopeProcessor((Set)localsSet, conflict, (Set)classesSet){
                final /* synthetic */ Set val$localsSet;
                final /* synthetic */ Ref val$conflict;
                final /* synthetic */ Set val$classesSet;
                {
                    this.val$localsSet = set;
                    this.val$conflict = ref;
                    this.val$classesSet = set2;
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    PsiClass psiClass;
                    String name2;
                    if (element instanceof PsiLocalVariable || element instanceof PsiPatternVariable) {
                        PsiVariable variable = (PsiVariable)element;
                        String name3 = variable.getName();
                        if (!this.val$localsSet.add(name3)) {
                            this.val$conflict.set((Object)Boolean.TRUE);
                            this.val$localsSet.clear();
                            this.val$classesSet.clear();
                        }
                    } else if (element instanceof PsiClass && !this.val$classesSet.add(name2 = (psiClass = (PsiClass)element).getName())) {
                        this.val$conflict.set((Object)Boolean.TRUE);
                        this.val$localsSet.clear();
                        this.val$classesSet.clear();
                    }
                    return (Boolean)this.val$conflict.get() == false;
                }
            }, PatternResolveState.WHEN_BOTH.putInto(ResolveState.initial()), (PsiElement)this, (PsiElement)this);
            set1 = classesSet.isEmpty() ? Collections.emptySet() : classesSet;
            this.myClassesSet = set1;
            set2 = localsSet.isEmpty() ? Collections.emptySet() : localsSet;
            this.myVariablesSet = set2;
            this.myConflict = wasConflict = ((Boolean)conflict.get()).booleanValue();
        }
        return wasConflict ? null : Couple.of(set1, set2);
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        block6: {
            block5: {
                if (anchor == null) {
                    if (before == null || before.booleanValue()) {
                        anchor = this.findChildByRole(19);
                        before = Boolean.TRUE;
                    } else {
                        anchor = this.findChildByRole(18);
                        before = Boolean.FALSE;
                    }
                }
                if (before != Boolean.TRUE) break block5;
                while (anchor != null && PsiCodeBlockImpl.isNonJavaStatement(anchor)) {
                    anchor = anchor.getTreePrev();
                    before = Boolean.FALSE;
                }
                break block6;
            }
            if (before != Boolean.FALSE) break block6;
            while (anchor != null && PsiCodeBlockImpl.isNonJavaStatement(anchor)) {
                anchor = anchor.getTreeNext();
                before = Boolean.TRUE;
            }
        }
        return super.addInternal(first, last, anchor, before);
    }

    private static boolean isNonJavaStatement(ASTNode anchor) {
        PsiElement psi = anchor.getPsi();
        return psi instanceof PsiStatement && psi.getLanguage() != JavaLanguage.INSTANCE;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.RBRACE);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.LBRACE) {
            return this.getChildRole(child, 18);
        }
        if (i == JavaTokenType.RBRACE) {
            return this.getChildRole(child, 19);
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitCodeBlock((PsiCodeBlock)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiCodeBlock";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        Couple<Set<String>> pair2 = this.buildMaps();
        boolean conflict = pair2 == null;
        Set classesSet = conflict ? null : (Set)pair2.getFirst();
        Set variablesSet = conflict ? null : (Set)pair2.getSecond();
        NameHint hint = (NameHint)processor2.getHint(NameHint.KEY);
        if (hint != null && !conflict) {
            ElementClassHint elementClassHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
            String name2 = hint.getName(state);
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && classesSet.contains(name2)) {
                return this.walkChildren(processor2, state, lastParent, place);
            }
            if ((elementClassHint == null || elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) && variablesSet.contains(name2)) {
                return this.walkChildren(processor2, state, lastParent, place);
            }
        } else {
            return this.walkChildren(processor2, state, lastParent, place);
        }
        return true;
    }

    private boolean walkChildren(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (!(this.getParent() instanceof PsiSwitchBlock)) {
            return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor2, state, lastParent, place);
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == this && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = this.getLastChild();
        }
        while (child != null) {
            if (child instanceof PsiSwitchLabelStatementBase) {
                state = PatternResolveState.WHEN_NONE.putInto(state);
            }
            if (!child.processDeclarations(processor2, state, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        PsiElement parent = this.getParent();
        return !(parent instanceof PsiMethod) && !(parent instanceof PsiClassInitializer);
    }
}

