/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBreakStatementImpl
extends CompositePsiElement
implements PsiBreakStatement {
    private static final Logger LOG = Logger.getInstance(PsiBreakStatementImpl.class);

    public PsiBreakStatementImpl() {
        super(JavaElementType.BREAK_STATEMENT);
    }

    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findPsiChildByType(JavaTokenType.IDENTIFIER);
    }

    @Nullable
    public PsiStatement findExitedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label != null) {
            PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement((PsiElement)this, label.getText());
            return labeled != null ? labeled.getStatement() : null;
        }
        return PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)this);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 81: {
                return this.findChildByType(JavaTokenType.BREAK_KEYWORD);
            }
            case 83: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.SEMICOLON);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.BREAK_KEYWORD) {
            return 81;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(i)) {
            return 83;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBreakStatement((PsiBreakStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiReference getReference() {
        PsiIdentifier label = this.getLabelIdentifier();
        return label != null ? new PsiLabelReference((PsiStatement)this, label) : null;
    }

    public String toString() {
        return "PsiBreakStatement";
    }
}

