/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ParameterElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance(ParameterElement.class);

    public ParameterElement(@NotNull IElementType type2) {
        super(type2);
    }

    public int getTextOffset() {
        ASTNode node = this.findChildByType(JavaTokenType.IDENTIFIER);
        return node != null ? node.getStartOffset() : this.getStartOffset();
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        if (role == 8) {
            return this.findChildByType(JavaElementType.MODIFIER_LIST);
        }
        if (role == 9) {
            return this.findChildByType(JavaTokenType.IDENTIFIER);
        }
        if (role == 10) {
            return this.findChildByType(JavaElementType.TYPE);
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        if (i == JavaElementType.TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        return 0;
    }
}

