/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ClassInitializerElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance(ClassInitializerElement.class);

    public ClassInitializerElement() {
        super(CLASS_INITIALIZER);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 17: 
        }
        return this.findChildByType((IElementType)CODE_BLOCK);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == C_STYLE_COMMENT || i == END_OF_LINE_COMMENT) {
            return 0;
        }
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == CODE_BLOCK) {
            return 17;
        }
        return 0;
    }
}

