/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGraphInferenceHelper
implements PsiInferenceHelper {
    private final PsiManager myManager;

    public PsiGraphInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        PsiSubstitutor substitutor;
        if (parent != null) {
            substitutor = this.inferTypeArguments(new PsiTypeParameter[]{typeParameter}, parameters2, arguments, null, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel((PsiElement)parent));
        } else {
            InferenceSession inferenceSession = new InferenceSession(new PsiTypeParameter[]{typeParameter}, partialSubstitutor, this.myManager, null, policy);
            inferenceSession.initExpressionConstraints(parameters2, arguments, null, false);
            substitutor = inferenceSession.infer();
        }
        return substitutor.substitute(typeParameter);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments, @Nullable MethodCandidateInfo currentMethod, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters.length == 0) {
            return partialSubstitutor;
        }
        return InferenceSessionContainer.infer(typeParameters, parameters2, arguments, partialSubstitutor, parent, policy, currentMethod);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull LanguageLevel languageLevel) {
        return this.inferTypeArguments(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        if (typeParameters.length == 0) {
            return PsiSubstitutor.EMPTY;
        }
        InferenceSession session = new InferenceSession(typeParameters, leftTypes, rightTypes, partialSubstitutor, this.myManager, null);
        for (PsiType leftType : leftTypes) {
            if (session.isProperType(session.substituteWithInferenceVariables(leftType))) continue;
            return session.infer();
        }
        for (PsiType rightType : rightTypes) {
            if (session.isProperType(session.substituteWithInferenceVariables(rightType))) continue;
            return session.infer();
        }
        return PsiSubstitutor.EMPTY;
    }

    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiTypeParameter[] psiTypeParameterArray;
        PsiType[] rightTypes;
        PsiType[] leftTypes;
        if (PsiType.VOID.equals((Object)arg) || PsiType.VOID.equals((Object)param)) {
            return PsiType.NULL;
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameter(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return PsiType.NULL;
        }
        if (arg == null) {
            return PsiType.NULL;
        }
        if (isContraVariantPosition) {
            leftTypes = new PsiType[]{param};
            rightTypes = new PsiType[]{arg};
        } else {
            leftTypes = new PsiType[]{arg};
            rightTypes = new PsiType[]{param};
        }
        PsiTypeParameterListOwner owner2 = typeParam.getOwner();
        if (owner2 != null) {
            psiTypeParameterArray = owner2.getTypeParameters();
        } else {
            PsiTypeParameter[] psiTypeParameterArray2 = new PsiTypeParameter[1];
            psiTypeParameterArray = psiTypeParameterArray2;
            psiTypeParameterArray2[0] = typeParam;
        }
        PsiTypeParameter[] typeParams = psiTypeParameterArray;
        InferenceSession inferenceSession = new InferenceSession(typeParams, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(param)) && inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(arg))) {
            boolean proceed = false;
            for (PsiClassType classType : typeParam.getExtendsListTypes()) {
                if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables((PsiType)classType))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                return PsiType.NULL;
            }
        }
        PsiSubstitutor substitutor = inferenceSession.infer();
        return substitutor.substitute(typeParam);
    }
}

