/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaVariableConflictResolver;
import com.intellij.psi.scope.processor.ConflictFilterProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariableResolverProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.VARIABLE;
    @NotNull
    private StaticScope myStaticScopeFlag = StaticScope.NON_STATIC;
    private final PsiClass myAccessClass;
    private PsiElement myCurrentFileContext;

    public VariableResolverProcessor(@NotNull PsiJavaCodeReferenceElement place, @NotNull PsiFile placeFile) {
        super(place.getReferenceName(), ourFilter, new PsiConflictResolver[]{new JavaVariableConflictResolver()}, (List<CandidateInfo>)new SmartList(), (PsiElement)place, placeFile);
        PsiClass access = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            JavaResolveResult accessClass = PsiUtil.getAccessObjectClass((PsiExpression)((PsiExpression)qualifier));
            PsiElement element = accessClass.getElement();
            if (element instanceof PsiTypeParameter) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)placeFile.getProject());
                PsiClassType type2 = factory.createType((PsiClass)((PsiTypeParameter)element));
                PsiType accessType = accessClass.getSubstitutor().substitute((PsiType)type2);
                if (accessType instanceof PsiArrayType) {
                    LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)placeFile);
                    access = factory.getArrayClass(languageLevel);
                } else if (accessType instanceof PsiClassType) {
                    access = ((PsiClassType)accessType).resolve();
                }
            } else if (element instanceof PsiClass) {
                access = (PsiClass)element;
            }
        }
        this.myAccessClass = access;
    }

    @Override
    protected boolean stopAtFoundResult(@NotNull JavaResolveResult cachedResult) {
        if (super.stopAtFoundResult(cachedResult)) {
            PsiElement element;
            JavaCodeFragment.VisibilityChecker visibilityChecker;
            if (this.myPlaceFile instanceof JavaCodeFragment && (visibilityChecker = ((JavaCodeFragment)this.myPlaceFile).getVisibilityChecker()) != null && (element = cachedResult.getElement()) instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                return JavaResolveUtil.isAccessible(member, member.getContainingClass(), member.getModifierList(), this.myPlace, this.myAccessClass, cachedResult.getCurrentFileResolveScope(), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        super.handleEvent(event, associated);
        if (JavaScopeProcessorEvent.isEnteringStaticScope((PsiScopeProcessor.Event)event, (Object)associated)) {
            if (this.myStaticScopeFlag != StaticScope.STATIC_NO_CONSTANTS) {
                this.myStaticScopeFlag = associated instanceof PsiClass && ((PsiClass)associated).getParent() instanceof PsiDeclarationStatement ? StaticScope.STATIC_NO_CONSTANTS : StaticScope.STATIC;
            }
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        boolean staticProblem = this.isStaticProblem(element);
        this.add(new CandidateInfo(element, substitutor, this.myPlace, this.myAccessClass, staticProblem, this.myCurrentFileContext));
    }

    private boolean isStaticProblem(@NotNull PsiElement element) {
        if (this.myStaticScopeFlag == StaticScope.NON_STATIC || ((PsiModifierListOwner)element).hasModifierProperty("static")) {
            return false;
        }
        if (element instanceof PsiField) {
            return true;
        }
        return this.myStaticScopeFlag != StaticScope.STATIC || !(element instanceof PsiVariable) || !PsiUtil.isCompileTimeConstant((PsiVariable)((PsiVariable)element));
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind2) {
        return kind2 == ElementClassHint.DeclarationKind.VARIABLE || kind2 == ElementClassHint.DeclarationKind.FIELD || kind2 == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (!(element instanceof PsiField) && (this.myName == null || PsiUtil.checkName((PsiElement)element, (String)this.myName, (PsiElement)this.myPlace))) {
            super.execute(element, state);
            return this.myResults.isEmpty();
        }
        return super.execute(element, state);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    private static enum StaticScope {
        NON_STATIC,
        STATIC,
        STATIC_NO_CONSTANTS;

    }
}

