/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.search.MethodDeepestSuperSearcher;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeStyleManagerImpl
extends JavaCodeStyleManager {
    private static final Logger LOG = Logger.getInstance(JavaCodeStyleManagerImpl.class);
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String GET_PREFIX = "get";
    @NonNls
    private static final String IS_PREFIX = "is";
    @NonNls
    private static final String FIND_PREFIX = "find";
    @NonNls
    private static final String CREATE_PREFIX = "create";
    @NonNls
    private static final String SET_PREFIX = "set";
    @NonNls
    private static final String[] ourPrepositions = new String[]{"as", "at", "by", "down", "for", "from", "in", "into", "of", "on", "onto", "out", "over", "per", "to", "up", "upon", "via", "with"};
    private final Project myProject;

    public JavaCodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element) throws IncorrectOperationException {
        return this.shortenClassReferences(element, 0);
    }

    @NotNull
    public PsiElement shortenClassReferences(@NotNull PsiElement element, int flags) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            return element;
        }
        boolean addImports = !BitUtil.isSet((int)flags, (int)4096);
        boolean incompleteCode = BitUtil.isSet((int)flags, (int)8192);
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), addImports, incompleteCode, this.myProject);
            return SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)reference);
        }
        return element;
    }

    public void shortenClassReferences(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        ReferenceAdjuster adjuster;
        CheckUtil.checkWritable((PsiElement)element);
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)element) && (adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage())) != null) {
            adjuster.processRange(element.getNode(), startOffset, endOffset, this.myProject);
        }
    }

    @NotNull
    public PsiElement qualifyClassReferences(@NotNull PsiElement element) {
        ReferenceAdjuster adjuster = ReferenceAdjuster.Extension.getReferenceAdjuster((Language)element.getLanguage());
        if (adjuster != null) {
            ASTNode reference = adjuster.process(element.getNode(), false, false, true, true);
            return SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)reference);
        }
        return element;
    }

    public void optimizeImports(@NotNull PsiFile file) throws IncorrectOperationException {
        PsiImportList importList;
        PsiImportList newList;
        CheckUtil.checkWritable((PsiElement)file);
        if (file instanceof PsiJavaFile && CodeStyle.isFormattingEnabled((PsiFile)file) && (newList = this.prepareOptimizeImportsResult((PsiJavaFile)file)) != null && (importList = ((PsiJavaFile)file).getImportList()) != null) {
            importList.getParent().addRangeAfter(newList.getParent().getFirstChild(), newList.getParent().getLastChild(), (PsiElement)importList);
            importList.delete();
        }
    }

    public PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile file) {
        return new ImportHelper(JavaCodeStyleSettings.getInstance((PsiFile)file)).prepareOptimizeImportsResult(file);
    }

    public boolean hasConflictingOnDemandImport(@NotNull PsiJavaFile file, @NotNull PsiClass psiClass, @NotNull String referenceName) {
        return ImportHelper.hasConflictingOnDemandImport(file, psiClass, referenceName);
    }

    public boolean addImport(@NotNull PsiJavaFile file, @NotNull PsiClass refClass) {
        return new ImportHelper(JavaCodeStyleSettings.getInstance((PsiFile)file)).addImport(file, refClass);
    }

    public void removeRedundantImports(@NotNull PsiJavaFile file) throws IncorrectOperationException {
        Collection<PsiImportStatementBase> redundant = this.findRedundantImports(file);
        if (redundant == null) {
            return;
        }
        for (PsiImportStatementBase importStatement : redundant) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || ref.resolve() == null) continue;
            importStatement.delete();
        }
    }

    @Nullable
    public Collection<PsiImportStatementBase> findRedundantImports(final @NotNull PsiJavaFile file) {
        Set redundant;
        PsiImportList importList = file.getImportList();
        if (importList == null) {
            return null;
        }
        Object[] imports2 = importList.getAllImportStatements();
        if (imports2.length == 0) {
            return null;
        }
        Set allImports = ContainerUtil.set((Object[])imports2);
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            redundant = new ReferenceOpenHashSet();
            ContainerUtil.addAll((Collection)redundant, (Object[])imports2);
            redundant.removeAll(allImports);
            for (Object importStatement : imports2) {
                if (!(importStatement instanceof JspxImportStatement) || !importStatement.isForeignFileImport()) continue;
                redundant.remove(importStatement);
            }
        } else {
            redundant = allImports;
            List roots = file.getViewProvider().getAllFiles();
            for (PsiElement root : roots) {
                root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                        PsiElement resolveScope;
                        JavaResolveResult resolveResult;
                        if (!reference.isQualified() && !this.inTheSamePackage(file, (resolveResult = reference.advancedResolve(false)).getElement()) && (resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
                            PsiImportStatementBase importStatementBase = (PsiImportStatementBase)resolveScope;
                            redundant.remove(importStatementBase);
                        }
                        super.visitReferenceElement(reference);
                    }

                    private boolean inTheSamePackage(PsiJavaFile file2, PsiElement element) {
                        PsiFile containingFile;
                        if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null && (containingFile = element.getContainingFile()) instanceof PsiJavaFile) {
                            return Comparing.strEqual((String)file2.getPackageName(), (String)((PsiJavaFile)containingFile).getPackageName());
                        }
                        return false;
                    }
                });
            }
        }
        return redundant;
    }

    public int findEntryIndex(@NotNull PsiImportStatementBase statement) {
        return new ImportHelper(JavaCodeStyleSettings.getInstance(statement.getContainingFile())).findEntryIndex(statement);
    }

    @Nullable
    public String suggestCompiledParameterName(@NotNull PsiType type2) {
        Collection<String> result = this.doSuggestParameterNamesByTypeWithoutIndex(type2);
        return (String)ContainerUtil.getFirstItem(this.getSuggestionsByNames(result, VariableKind.PARAMETER, true));
    }

    @NotNull
    public SuggestedNameInfo suggestVariableName(final @NotNull VariableKind kind2, @Nullable String propertyName, @Nullable PsiExpression expr2, @Nullable PsiType type2, boolean correctKeywords) {
        NamesByExprInfo namesByExpr;
        if (expr2 != null && type2 == null) {
            type2 = expr2.getType();
        }
        LinkedHashSet names2 = new LinkedHashSet();
        if (propertyName != null) {
            Object[] namesByName = ArrayUtilRt.toStringArray(this.getSuggestionsByName(propertyName, kind2, correctKeywords));
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByName, kind2, propertyName, null);
            ContainerUtil.addAll(names2, (Object[])namesByName);
        }
        if (expr2 != null) {
            namesByExpr = this.suggestVariableNameByExpression(expr2, kind2);
            Object[] suggestions = ArrayUtilRt.toStringArray(this.getSuggestionsByNames(namesByExpr.names, kind2, correctKeywords));
            if (namesByExpr.propertyName != null) {
                JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])suggestions, kind2, namesByExpr.propertyName, null);
            }
            ContainerUtil.addAll(names2, (Object[])suggestions);
        } else {
            namesByExpr = null;
        }
        if (type2 != null) {
            Object[] namesByType = this.suggestVariableNameByType(type2, kind2, correctKeywords);
            JavaCodeStyleManagerImpl.sortVariableNameSuggestions((String[])namesByType, kind2, null, type2);
            ContainerUtil.addAll(names2, (Object[])namesByType);
        }
        final String _propertyName = propertyName != null ? propertyName : (namesByExpr != null ? namesByExpr.propertyName : null);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(names2, kind2, _propertyName, type2);
        String[] namesArray = ArrayUtilRt.toStringArray(names2);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind2, _propertyName, type2);
        final PsiType _type = type2;
        return new SuggestedNameInfo(namesArray){

            public void nameChosen(String name2) {
                if (_propertyName != null || _type != null && _type.isValid()) {
                    JavaStatisticsManager.incVariableNameUseCount((String)name2, (VariableKind)kind2, (String)_propertyName, (PsiType)_type);
                }
            }
        };
    }

    private static void addNamesFromStatistics(@NotNull Set<? super String> names2, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type2) {
        String[] allNames = JavaStatisticsManager.getAllVariableNamesUsed((VariableKind)variableKind, (String)propertyName, (PsiType)type2);
        int maxFrequency = 0;
        for (String name2 : allNames) {
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            maxFrequency = Math.max(maxFrequency, count);
        }
        int frequencyLimit = Math.max(5, maxFrequency / 2);
        for (String name3 : allNames) {
            if (names2.contains(name3)) continue;
            int count = JavaStatisticsManager.getVariableNameUseCount((String)name3, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("new name:" + name3 + " count:" + count);
                LOG.debug("frequencyLimit:" + frequencyLimit);
            }
            if (count < frequencyLimit) continue;
            names2.add(name3);
        }
        if (propertyName != null && type2 != null) {
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names2, variableKind, propertyName, null);
            JavaCodeStyleManagerImpl.addNamesFromStatistics(names2, variableKind, null, type2);
        }
    }

    private String @NotNull [] suggestVariableNameByType(@NotNull PsiType type2, @NotNull VariableKind variableKind, boolean correctKeywords) {
        Collection<String> byTypeNames = this.doSuggestNamesByType(type2, variableKind);
        return ArrayUtilRt.toStringArray(this.getSuggestionsByNames(byTypeNames, variableKind, correctKeywords));
    }

    @NotNull
    private Collection<String> doSuggestParameterNamesByTypeWithoutIndex(@NotNull PsiType type2) {
        String fromTypeMap = this.suggestNameFromTypeMap(type2, VariableKind.PARAMETER, type2.getCanonicalText());
        if (fromTypeMap != null) {
            return Collections.singletonList(fromTypeMap);
        }
        return JavaCodeStyleManagerImpl.suggestNamesFromTypeName(type2, VariableKind.PARAMETER, JavaCodeStyleManagerImpl.getTypeNameWithoutIndex(type2.getDeepComponentType()));
    }

    @NotNull
    private Collection<String> doSuggestNamesByType(@NotNull PsiType type2, @NotNull VariableKind variableKind) {
        String fromTypeMap = this.suggestNameFromTypeMap(type2, variableKind, JavaCodeStyleManagerImpl.getLongTypeName(type2));
        if (fromTypeMap != null) {
            return Collections.singletonList(fromTypeMap);
        }
        List<String> fromTypeName = JavaCodeStyleManagerImpl.suggestNamesFromTypeName(type2, variableKind, JavaCodeStyleManagerImpl.getTypeName(type2));
        if (!(type2 instanceof PsiClassType)) {
            return fromTypeName;
        }
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        PsiClassType classType = (PsiClassType)type2;
        JavaCodeStyleManagerImpl.suggestNamesForCollectionInheritors(classType, suggestions);
        this.suggestFromOptionalContent(variableKind, classType, suggestions);
        JavaCodeStyleManagerImpl.suggestNamesFromGenericParameters(classType, suggestions);
        suggestions.addAll(fromTypeName);
        JavaCodeStyleManagerImpl.suggestNamesFromHierarchy(classType, suggestions);
        return suggestions;
    }

    @Nullable
    private String suggestNameFromTypeMap(@NotNull PsiType type2, @NotNull VariableKind variableKind, @Nullable String longTypeName) {
        if (longTypeName != null) {
            String name2;
            if (type2.equals(PsiType.NULL)) {
                longTypeName = "java.lang.Object";
            }
            if ((name2 = JavaCodeStyleManagerImpl.nameByType(longTypeName, variableKind)) != null && this.isIdentifier(name2)) {
                return type2 instanceof PsiArrayType ? StringUtil.pluralize((String)name2) : name2;
            }
        }
        return null;
    }

    @Nullable
    private static String nameByType(@NotNull String longTypeName, @NotNull VariableKind kind2) {
        if (kind2 == VariableKind.PARAMETER || kind2 == VariableKind.LOCAL_VARIABLE) {
            switch (longTypeName) {
                case "int": 
                case "boolean": 
                case "byte": 
                case "char": 
                case "long": {
                    return longTypeName.substring(0, 1);
                }
                case "double": 
                case "float": {
                    return "v";
                }
                case "short": {
                    return "i";
                }
                case "java.lang.Object": {
                    return "o";
                }
                case "java.lang.String": {
                    return "s";
                }
                case "java.lang.Void": {
                    return "unused";
                }
            }
        }
        return null;
    }

    private void suggestFromOptionalContent(@NotNull VariableKind variableKind, @NotNull PsiClassType classType, @NotNull Collection<? super String> suggestions) {
        PsiType optionalContent = JavaCodeStyleManagerImpl.extractOptionalContent(classType);
        if (optionalContent == null) {
            return;
        }
        Collection<String> contentSuggestions = this.doSuggestNamesByType(optionalContent, variableKind);
        suggestions.addAll(contentSuggestions);
        for (String s : contentSuggestions) {
            suggestions.add("optional" + StringUtil.capitalize((String)s));
        }
    }

    @NotNull
    private static List<String> suggestNamesFromTypeName(@NotNull PsiType type2, @NotNull VariableKind variableKind, @Nullable String typeName) {
        String result;
        if (typeName == null) {
            return Collections.emptyList();
        }
        typeName = JavaCodeStyleManagerImpl.normalizeTypeName(typeName);
        String string = result = type2 instanceof PsiArrayType ? StringUtil.pluralize((String)typeName) : typeName;
        if (variableKind == VariableKind.PARAMETER && type2 instanceof PsiClassType && typeName.endsWith("Exception")) {
            return Arrays.asList("e", result);
        }
        return Collections.singletonList(result);
    }

    @Nullable
    private static PsiType extractOptionalContent(@NotNull PsiClassType classType) {
        PsiClass resolved = classType.resolve();
        if (resolved != null && "java.util.Optional".equals(resolved.getQualifiedName()) && classType.getParameterCount() == 1) {
            return classType.getParameters()[0];
        }
        return null;
    }

    private static void suggestNamesFromHierarchy(@NotNull PsiClassType type2, @NotNull Collection<? super String> suggestions) {
        PsiClass resolved = type2.resolve();
        if (resolved == null || resolved.getContainingClass() == null) {
            return;
        }
        InheritanceUtil.processSupers((PsiClass)resolved, (boolean)false, superClass -> {
            if (PsiTreeUtil.isAncestor((PsiElement)superClass, (PsiElement)resolved, (boolean)true)) {
                suggestions.add(superClass.getName());
            }
            return false;
        });
    }

    private static void suggestNamesFromGenericParameters(@NotNull PsiClassType type2, @NotNull Collection<? super String> suggestions) {
        PsiType[] parameters2 = type2.getParameters();
        if (parameters2.length == 0) {
            return;
        }
        StringBuilder fullNameBuilder = new StringBuilder();
        for (PsiType parameter2 : parameters2) {
            String typeName;
            if (!(parameter2 instanceof PsiClassType) || (typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(parameter2))) == null) continue;
            fullNameBuilder.append(typeName);
        }
        String baseName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName((PsiType)type2));
        if (baseName != null) {
            fullNameBuilder.append(baseName);
            suggestions.add(fullNameBuilder.toString());
        }
    }

    private static void suggestNamesForCollectionInheritors(@NotNull PsiClassType type2, @NotNull Collection<? super String> suggestions) {
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)false);
        if (componentType == null || componentType.equals(type2)) {
            return;
        }
        String typeName = JavaCodeStyleManagerImpl.normalizeTypeName(JavaCodeStyleManagerImpl.getTypeName(componentType));
        if (typeName != null) {
            suggestions.add(StringUtil.pluralize((String)typeName));
        }
    }

    private static String normalizeTypeName(@Nullable String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @Nullable
    private static String getTypeNameWithoutIndex(@NotNull PsiType type2) {
        return (type2 = type2.getDeepComponentType()) instanceof PsiClassType ? ((PsiClassType)type2).getClassName() : (type2 instanceof PsiPrimitiveType ? type2.getPresentableText() : null);
    }

    @Nullable
    public static String getTypeName(@NotNull PsiType type2) {
        if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            String className2 = classType.getClassName();
            if (className2 != null) {
                return className2;
            }
            PsiClass aClass = classType.resolve();
            return aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getClassName() : null;
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.getPresentableText();
        }
        if (type2 instanceof PsiWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiWildcardType)type2).getExtendsBound());
        }
        if (type2 instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiIntersectionType)type2).getRepresentative());
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaCodeStyleManagerImpl.getTypeName((PsiType)((PsiCapturedWildcardType)type2).getWildcard());
        }
        if (type2 instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getTypeName(((PsiDisjunctionType)type2).getLeastUpperBound());
        }
        return null;
    }

    @Nullable
    private static String getLongTypeName(@NotNull PsiType type2) {
        if (type2 instanceof PsiClassType) {
            PsiClass aClass = ((PsiClassType)type2).resolve();
            if (aClass == null) {
                return null;
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiClass baseClass = ((PsiAnonymousClass)aClass).getBaseClassType().resolve();
                return baseClass != null ? baseClass.getQualifiedName() : null;
            }
            return aClass.getQualifiedName();
        }
        if (type2 instanceof PsiArrayType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiArrayType)type2).getComponentType()) + "[]";
        }
        if (type2 instanceof PsiPrimitiveType) {
            return type2.getPresentableText();
        }
        if (type2 instanceof PsiWildcardType) {
            PsiType bound = ((PsiWildcardType)type2).getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            PsiType bound = ((PsiCapturedWildcardType)type2).getWildcard().getBound();
            return bound != null ? JavaCodeStyleManagerImpl.getLongTypeName(bound) : "java.lang.Object";
        }
        if (type2 instanceof PsiIntersectionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiIntersectionType)type2).getRepresentative());
        }
        if (type2 instanceof PsiDisjunctionType) {
            return JavaCodeStyleManagerImpl.getLongTypeName(((PsiDisjunctionType)type2).getLeastUpperBound());
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpression(@NotNull PsiExpression expr2, @Nullable VariableKind variableKind) {
        LinkedHashSet<String> names2 = new LinkedHashSet<String>();
        ContainerUtil.addIfNotNull(names2, (Object)JavaCodeStyleManagerImpl.suggestVariableNameFromLiterals(expr2));
        NamesByExprInfo byExpr = this.suggestVariableNameByExpressionOnly(expr2, variableKind, false);
        NamesByExprInfo byExprPlace = this.suggestVariableNameByExpressionPlace(expr2, variableKind);
        NamesByExprInfo byExprAllMethods = this.suggestVariableNameByExpressionOnly(expr2, variableKind, true);
        names2.addAll(byExpr.names);
        names2.addAll(byExprPlace.names);
        PsiType type2 = expr2.getType();
        if (type2 != null && variableKind != null) {
            names2.addAll(this.doSuggestNamesByType(type2, variableKind));
        }
        names2.addAll(byExprAllMethods.names);
        String propertyName = byExpr.propertyName != null ? byExpr.propertyName : byExprPlace.propertyName;
        return new NamesByExprInfo(propertyName, names2);
    }

    @Nullable
    private static String suggestVariableNameFromLiterals(@NotNull PsiExpression expr2) {
        String text2 = JavaCodeStyleManagerImpl.findLiteralText(expr2);
        if (text2 == null) {
            return null;
        }
        return expr2.getType() instanceof PsiArrayType ? StringUtil.pluralize((String)text2) : text2;
    }

    private static boolean isNameSupplier(String text2) {
        if (!StringUtil.isQuotedString((String)text2)) {
            return false;
        }
        String stringPresentation = StringUtil.unquoteString((String)text2);
        String[] words = stringPresentation.split(" ");
        if (words.length > 5) {
            return false;
        }
        return Arrays.stream(words).allMatch(StringUtil::isJavaIdentifier);
    }

    @Nullable
    private static String findLiteralText(@NotNull PsiExpression expr2) {
        PsiLiteralExpression[] literals = (PsiLiteralExpression[])SyntaxTraverser.psiTraverser((PsiElement)expr2).filter(PsiLiteralExpression.class).filter(lit -> JavaCodeStyleManagerImpl.isNameSupplier(lit.getText())).filter(lit -> {
            PsiElement exprList = lit.getParent();
            if (!(exprList instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement call = exprList.getParent();
            return call instanceof PsiNewExpression || call instanceof PsiMethodCallExpression;
        }).toArray((Object[])new PsiLiteralExpression[0]);
        if (literals.length == 1) {
            return StringUtil.unquoteString((String)literals[0].getText()).replaceAll(" ", "_");
        }
        return null;
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionOnly(@NotNull PsiExpression expr2, @Nullable VariableKind variableKind, boolean useAllMethodNames) {
        PsiType functionalInterfaceType;
        if (expr2 instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)expr2).getMethodExpression();
            String methodName = methodExpr.getReferenceName();
            if (methodName != null) {
                PsiExpression[] expressions2;
                if (("of".equals(methodName) || "ofNullable".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr2) && (expressions2 = ((PsiMethodCallExpression)expr2).getArgumentList().getExpressions()).length > 0) {
                    return this.suggestVariableNameByExpressionOnly(expressions2[0], variableKind, useAllMethodNames);
                }
                if (("map".equals(methodName) || "flatMap".equals(methodName) || "filter".equals(methodName)) && JavaCodeStyleManagerImpl.isJavaUtilMethodCall((PsiMethodCallExpression)expr2)) {
                    return NamesByExprInfo.EMPTY;
                }
                String[] words = NameUtilCore.nameToWords((String)methodName);
                if (words.length > 0) {
                    String firstWord = words[0];
                    if (GET_PREFIX.equals(firstWord) || IS_PREFIX.equals(firstWord) || FIND_PREFIX.equals(firstWord) || CREATE_PREFIX.equals(firstWord)) {
                        if (words.length > 1) {
                            String propertyName = methodName.substring(firstWord.length());
                            PsiExpression qualifierExpression2 = methodExpr.getQualifierExpression();
                            if (qualifierExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression2).resolve() instanceof PsiVariable) {
                                String name2 = ((PsiReferenceExpression)qualifierExpression2).getReferenceName() + StringUtil.capitalize((String)propertyName);
                                return new NamesByExprInfo(propertyName, new String[]{name2});
                            }
                            return new NamesByExprInfo(propertyName);
                        }
                    } else if (words.length == 1 || useAllMethodNames) {
                        return new NamesByExprInfo(methodName);
                    }
                }
            }
        } else if (expr2 instanceof PsiReferenceExpression) {
            String propertyName = this.getPropertyName((PsiReferenceExpression)expr2, true);
            if (propertyName != null) {
                return new NamesByExprInfo(propertyName);
            }
        } else if (expr2 instanceof PsiArrayAccessExpression) {
            String singular;
            NamesByExprInfo info = this.suggestVariableNameByExpressionOnly(((PsiArrayAccessExpression)expr2).getArrayExpression(), variableKind, useAllMethodNames);
            String string = singular = info.propertyName == null ? null : StringUtil.unpluralize((String)info.propertyName);
            if (singular != null) {
                return new NamesByExprInfo(singular, ContainerUtil.mapNotNull((Collection)info.names, StringUtil::unpluralize));
            }
        } else if (expr2 instanceof PsiLiteralExpression && variableKind == VariableKind.STATIC_FINAL_FIELD) {
            String stringValue;
            String[] names2;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr2;
            Object value2 = literalExpression.getValue();
            if (value2 instanceof String && (names2 = JavaCodeStyleManagerImpl.getSuggestionsByValue(stringValue = (String)value2)).length > 0) {
                return new NamesByExprInfo(null, new String[]{JavaCodeStyleManagerImpl.constantValueToConstantName(names2)});
            }
        } else if (expr2 instanceof PsiParenthesizedExpression) {
            PsiExpression expression2 = ((PsiParenthesizedExpression)expr2).getExpression();
            if (expression2 != null) {
                return this.suggestVariableNameByExpressionOnly(expression2, variableKind, useAllMethodNames);
            }
        } else if (expr2 instanceof PsiTypeCastExpression) {
            PsiExpression operand2 = ((PsiTypeCastExpression)expr2).getOperand();
            if (operand2 != null) {
                return this.suggestVariableNameByExpressionOnly(operand2, variableKind, useAllMethodNames);
            }
        } else if (expr2 instanceof PsiLiteralExpression) {
            String text2 = StringUtil.unquoteString((String)expr2.getText());
            if (this.isIdentifier(text2)) {
                return new NamesByExprInfo(text2);
            }
        } else if (expr2 instanceof PsiFunctionalExpression && variableKind != null && (functionalInterfaceType = ((PsiFunctionalExpression)expr2).getFunctionalInterfaceType()) != null) {
            return new NamesByExprInfo(null, this.doSuggestNamesByType(functionalInterfaceType, variableKind));
        }
        return NamesByExprInfo.EMPTY;
    }

    private static boolean isJavaUtilMethodCall(@NotNull PsiMethodCallExpression expr2) {
        PsiMethod method = expr2.resolveMethod();
        if (method == null) {
            return false;
        }
        return JavaCodeStyleManagerImpl.isJavaUtilMethod(method) || !MethodDeepestSuperSearcher.processDeepestSuperMethods(method, (Processor<? super PsiMethod>)((Processor)method1 -> !JavaCodeStyleManagerImpl.isJavaUtilMethod(method1)));
    }

    private static boolean isJavaUtilMethod(@NotNull PsiMethod method) {
        String name2 = PsiUtil.getMemberQualifiedName((PsiMember)method);
        return name2 != null && name2.startsWith("java.util.");
    }

    @Nullable
    private String getPropertyName(@NotNull PsiReferenceExpression expression2) {
        return this.getPropertyName(expression2, false);
    }

    @Nullable
    private String getPropertyName(@NotNull PsiReferenceExpression expression2, boolean skipUnresolved) {
        String propertyName = expression2.getReferenceName();
        if (propertyName == null) {
            return null;
        }
        PsiElement refElement = expression2.resolve();
        if (refElement instanceof PsiVariable) {
            VariableKind refVariableKind = this.getVariableKind((PsiVariable)refElement);
            return this.variableNameToPropertyName(propertyName, refVariableKind);
        }
        if (refElement == null && skipUnresolved) {
            return null;
        }
        return propertyName;
    }

    @NotNull
    private static String constantValueToConstantName(String @NotNull [] names2) {
        return String.join((CharSequence)"_", names2);
    }

    private static String @NotNull [] getSuggestionsByValue(@NotNull String stringValue) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        boolean prevIsUpperCase = false;
        for (int i = 0; i < stringValue.length(); ++i) {
            char c = stringValue.charAt(i);
            if (Character.isUpperCase(c)) {
                if (currentWord.length() > 0 && !prevIsUpperCase) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                currentWord.append(c);
            } else if (Character.isLowerCase(c)) {
                currentWord.append(Character.toUpperCase(c));
            } else if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isJavaIdentifierStart(c) || currentWord.length() > 0 || !result.isEmpty()) {
                    currentWord.append(c);
                }
            } else if (currentWord.length() > 0) {
                result.add(currentWord.toString());
                currentWord = new StringBuffer();
            }
            prevIsUpperCase = Character.isUpperCase(c);
        }
        if (currentWord.length() > 0) {
            result.add(currentWord.toString());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    @NotNull
    private NamesByExprInfo suggestVariableNameByExpressionPlace(@NotNull PsiExpression expr2, @Nullable VariableKind variableKind) {
        PsiVariable variable;
        String variableName2;
        if (expr2.getParent() instanceof PsiExpressionList) {
            PsiExpressionList list = (PsiExpressionList)expr2.getParent();
            PsiElement listParent = list.getParent();
            PsiSubstitutor subst = PsiSubstitutor.EMPTY;
            PsiMethod method = null;
            if (listParent instanceof PsiMethodCallExpression) {
                JavaResolveResult resolveResult = ((PsiMethodCallExpression)listParent).getMethodExpression().advancedResolve(false);
                method = (PsiMethod)resolveResult.getElement();
                subst = resolveResult.getSubstitutor();
            } else {
                if (listParent instanceof PsiAnonymousClass) {
                    listParent = listParent.getParent();
                }
                if (listParent instanceof PsiNewExpression) {
                    method = ((PsiNewExpression)listParent).resolveConstructor();
                }
            }
            if (method != null) {
                PsiParameter[] parameters2;
                Object[] expressions2;
                int index;
                PsiElement navElement = method.getNavigationElement();
                if (navElement instanceof PsiMethod) {
                    method = (PsiMethod)navElement;
                }
                if ((index = ArrayUtil.indexOf((Object[])(expressions2 = list.getExpressions()), (Object)expr2)) < (parameters2 = method.getParameterList().getParameters()).length) {
                    String name2 = parameters2[index].getName();
                    if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)subst.substitute(parameters2[index].getType()), (PsiExpression)expr2)) {
                        String firstWord;
                        String methodName;
                        String[] words;
                        name2 = this.variableNameToPropertyName(name2, VariableKind.PARAMETER);
                        if (expressions2.length == 1 && (words = NameUtilCore.nameToWords((String)(methodName = method.getName()))).length > 0 && SET_PREFIX.equals(firstWord = words[0])) {
                            String propertyName = methodName.substring(firstWord.length());
                            return new NamesByExprInfo(name2, new String[]{propertyName});
                        }
                        return new NamesByExprInfo(name2);
                    }
                }
            }
        } else if (expr2.getParent() instanceof PsiAssignmentExpression) {
            String name3;
            PsiExpression leftExpression;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expr2.getParent();
            if (expr2 == assignmentExpression.getRExpression() && (leftExpression = assignmentExpression.getLExpression()) instanceof PsiReferenceExpression && (name3 = this.getPropertyName((PsiReferenceExpression)leftExpression)) != null) {
                return new NamesByExprInfo(name3);
            }
        } else if (expr2.getParent() instanceof PsiLocalVariable && variableKind != VariableKind.LOCAL_VARIABLE && (variableName2 = (variable = (PsiVariable)expr2.getParent()).getName()) != null) {
            String propertyName = this.variableNameToPropertyName(variableName2, this.getVariableKind(variable));
            return new NamesByExprInfo(propertyName);
        }
        return NamesByExprInfo.EMPTY;
    }

    @NotNull
    public String variableNameToPropertyName(@NotNull String name2, @NotNull VariableKind variableKind) {
        if (variableKind == VariableKind.STATIC_FINAL_FIELD || variableKind == VariableKind.STATIC_FIELD && name2.contains("_")) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c != '_') {
                    if (Character.isLowerCase(c)) {
                        return this.variableNameToPropertyNameInner(name2, variableKind);
                    }
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (++i >= name2.length()) continue;
                c = name2.charAt(i);
                buffer.append(c);
            }
            return buffer.toString();
        }
        return this.variableNameToPropertyNameInner(name2, variableKind);
    }

    @NotNull
    private String variableNameToPropertyNameInner(@NotNull String name2, @NotNull VariableKind variableKind) {
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        boolean doDecapitalize = false;
        int pLength = prefix.length();
        if (pLength > 0 && name2.startsWith(prefix) && name2.length() > pLength && (!Character.isLetter(prefix.charAt(pLength - 1)) || Character.isUpperCase(name2.charAt(pLength)))) {
            name2 = name2.substring(pLength);
            doDecapitalize = true;
        }
        if (name2.endsWith(suffix) && name2.length() > suffix.length()) {
            name2 = name2.substring(0, name2.length() - suffix.length());
            doDecapitalize = true;
        }
        if (doDecapitalize) {
            name2 = Introspector.decapitalize(name2);
        }
        return name2;
    }

    @NotNull
    public String propertyNameToVariableName(@NotNull String propertyName, @NotNull VariableKind variableKind) {
        if (variableKind == VariableKind.STATIC_FINAL_FIELD) {
            Object[] words = NameUtilCore.nameToWords((String)propertyName);
            return StringUtil.join((Object[])words, StringUtil::toUpperCase, (String)"_");
        }
        String prefix = this.getPrefixByVariableKind(variableKind);
        String name2 = propertyName;
        if (!(name2.isEmpty() || prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_'))) {
            name2 = Character.toUpperCase(name2.charAt(0)) + name2.substring(1);
        }
        name2 = prefix + name2 + this.getSuffixByVariableKind(variableKind);
        name2 = this.changeIfNotIdentifier(name2);
        return name2;
    }

    @NotNull
    private Collection<String> getSuggestionsByNames(@NotNull Iterable<String> names2, @NotNull VariableKind kind2, boolean correctKeywords) {
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        for (String name2 : names2) {
            suggestions.addAll(this.getSuggestionsByName(name2, kind2, correctKeywords));
        }
        return suggestions;
    }

    @NotNull
    private Collection<String> getSuggestionsByName(@NotNull String name2, @NotNull VariableKind variableKind, boolean correctKeywords) {
        boolean upperCaseStyle = variableKind == VariableKind.STATIC_FINAL_FIELD;
        boolean preferLongerNames = this.getJavaSettings().PREFER_LONGER_NAMES;
        String prefix = this.getPrefixByVariableKind(variableKind);
        String suffix = this.getSuffixByVariableKind(variableKind);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : NameUtil.getSuggestionsByName((String)name2, (String)prefix, (String)suffix, (boolean)upperCaseStyle, (boolean)preferLongerNames, (boolean)false)) {
            answer.add(correctKeywords ? this.changeIfNotIdentifier(suggestion) : suggestion);
        }
        String wordByPreposition = JavaCodeStyleManagerImpl.getWordByPreposition(name2, prefix, suffix, upperCaseStyle);
        if (wordByPreposition != null && (!correctKeywords || this.isIdentifier(wordByPreposition))) {
            answer.add(wordByPreposition);
        }
        return answer;
    }

    private static String getWordByPreposition(@NotNull String name2, String prefix, String suffix, boolean upperCaseStyle) {
        String[] words = NameUtil.splitNameIntoWords((String)name2);
        for (int i = 1; i < words.length; ++i) {
            for (String preposition : ourPrepositions) {
                if (!preposition.equalsIgnoreCase(words[i])) continue;
                String mainWord = words[i - 1];
                mainWord = upperCaseStyle ? StringUtil.toUpperCase((String)mainWord) : (prefix.isEmpty() || StringUtil.endsWithChar((CharSequence)prefix, (char)'_') ? StringUtil.toLowerCase((String)mainWord) : StringUtil.capitalize((String)mainWord));
                return prefix + mainWord + suffix;
            }
        }
        return null;
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward) {
        return JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, lookForward, false, v -> place instanceof PsiParameter && !PsiTreeUtil.isAncestor((PsiElement)((PsiParameter)place).getDeclarationScope(), (PsiElement)v, (boolean)false));
    }

    @NotNull
    public String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, Predicate<? super PsiVariable> canBeReused) {
        return JavaCodeStyleManagerImpl.suggestUniqueVariableName(baseName, place, true, false, canBeReused);
    }

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(final @NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean ignorePlaceName, boolean lookForward) {
        String[] names2 = baseNameInfo.names;
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>(names2.length);
        for (String name2 : names2) {
            String withShadowing;
            String placeName;
            if (ignorePlaceName && place instanceof PsiNamedElement && Comparing.strEqual((String)(placeName = ((PsiNamedElement)place).getName()), (String)name2)) {
                uniqueNames.add(name2);
                continue;
            }
            String unique = this.suggestUniqueVariableName(name2, place, lookForward);
            if (!unique.equals(name2) && (withShadowing = JavaCodeStyleManagerImpl.suggestUniqueVariableName(name2, place, lookForward, true, v -> false)).equals(name2)) {
                uniqueNames.add(name2);
            }
            uniqueNames.add(unique);
        }
        return new SuggestedNameInfo(ArrayUtilRt.toStringArray(uniqueNames)){

            public void nameChosen(String name2) {
                baseNameInfo.nameChosen(name2);
            }
        };
    }

    @NotNull
    private static String suggestUniqueVariableName(@NotNull String baseName, PsiElement place, boolean lookForward, boolean allowShadowing, Predicate<? super PsiVariable> canBeReused) {
        PsiElement scope = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class, PsiMethod.class});
        int index = 0;
        while (true) {
            String name2;
            String string = name2 = index > 0 ? baseName + index : baseName;
            if (!(JavaCodeStyleManagerImpl.hasConflictingVariable(place, name2, allowShadowing) || lookForward && JavaCodeStyleManagerImpl.hasConflictingVariableAfterwards(scope, name2, canBeReused))) {
                return name2;
            }
            ++index;
        }
    }

    private static boolean hasConflictingVariable(@Nullable PsiElement place, @NotNull String name2, boolean allowShadowing) {
        if (place == null) {
            return false;
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
        PsiVariable existingVariable = helper.resolveAccessibleReferencedVariable(name2, place);
        if (existingVariable == null) {
            return false;
        }
        return !allowShadowing || !(existingVariable instanceof PsiField) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiMethod.class}) == null;
    }

    private static boolean hasConflictingVariableAfterwards(@Nullable PsiElement scope, final @NotNull String name2, final @NotNull Predicate<? super PsiVariable> canBeReused) {
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean hasConflict = false;

            Visitor() {
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitVariable(PsiVariable variable) {
                if (name2.equals(variable.getName()) && !canBeReused.test(variable)) {
                    this.hasConflict = true;
                    this.stopWalking();
                }
                super.visitVariable(variable);
            }
        }
        Visitor visitor2 = new Visitor();
        for (PsiElement run2 = scope; run2 != null; run2 = run2.getNextSibling()) {
            run2.accept((PsiElementVisitor)visitor2);
            if (!visitor2.hasConflict) continue;
            return true;
        }
        return false;
    }

    private static void sortVariableNameSuggestions(String @NotNull [] names2, @NotNull VariableKind variableKind, @Nullable String propertyName, @Nullable PsiType type2) {
        if (names2.length <= 1) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorting names:" + variableKind);
            if (propertyName != null) {
                LOG.debug("propertyName:" + propertyName);
            }
            if (type2 != null) {
                LOG.debug("type:" + type2);
            }
            for (String name2 : names2) {
                int count = JavaStatisticsManager.getVariableNameUseCount((String)name2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
                LOG.debug(name2 + " : " + count);
            }
        }
        Comparator comparator = (s1, s2) -> {
            int count1 = JavaStatisticsManager.getVariableNameUseCount((String)s1, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            int count2 = JavaStatisticsManager.getVariableNameUseCount((String)s2, (VariableKind)variableKind, (String)propertyName, (PsiType)type2);
            return count2 - count1;
        };
        Arrays.sort(names2, comparator);
    }

    @NotNull
    public String getPrefixByVariableKind(@NotNull VariableKind variableKind) {
        String prefix = null;
        switch (variableKind) {
            case FIELD: {
                prefix = this.getJavaSettings().FIELD_NAME_PREFIX;
                break;
            }
            case STATIC_FIELD: {
                prefix = this.getJavaSettings().STATIC_FIELD_NAME_PREFIX;
                break;
            }
            case PARAMETER: {
                prefix = this.getJavaSettings().PARAMETER_NAME_PREFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                prefix = this.getJavaSettings().LOCAL_VARIABLE_NAME_PREFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        return prefix == null ? "" : prefix;
    }

    @NotNull
    public String getSuffixByVariableKind(@NotNull VariableKind variableKind) {
        String suffix = null;
        switch (variableKind) {
            case FIELD: {
                suffix = this.getJavaSettings().FIELD_NAME_SUFFIX;
                break;
            }
            case STATIC_FIELD: {
                suffix = this.getJavaSettings().STATIC_FIELD_NAME_SUFFIX;
                break;
            }
            case PARAMETER: {
                suffix = this.getJavaSettings().PARAMETER_NAME_SUFFIX;
                break;
            }
            case LOCAL_VARIABLE: {
                suffix = this.getJavaSettings().LOCAL_VARIABLE_NAME_SUFFIX;
                break;
            }
            case STATIC_FINAL_FIELD: {
                break;
            }
            default: {
                LOG.assertTrue(false);
            }
        }
        return suffix == null ? "" : suffix;
    }

    @NotNull
    public Collection<String> suggestSemanticNames(@NotNull PsiExpression expression2) {
        return this.suggestVariableNameByExpression(expression2, null).names;
    }

    @NotNull
    private Collection<String> suggestSemanticNamesByType(@Nullable PsiType type2, @NotNull VariableKind kind2) {
        return type2 == null ? Collections.emptyList() : this.doSuggestNamesByType(type2, kind2);
    }

    @NotNull
    public SuggestedNameInfo suggestNames(@NotNull Collection<String> semanticNames, final @NotNull VariableKind kind2, final @Nullable PsiType type2) {
        Iterable allSemanticNames = ContainerUtil.concat(semanticNames, this.suggestSemanticNamesByType(type2, kind2));
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>(this.getSuggestionsByNames(allSemanticNames, kind2, true));
        final String propertyName = (String)ContainerUtil.getFirstItem(semanticNames);
        JavaCodeStyleManagerImpl.addNamesFromStatistics(suggestions, kind2, propertyName, type2);
        String[] namesArray = ArrayUtilRt.toStringArray(suggestions);
        JavaCodeStyleManagerImpl.sortVariableNameSuggestions(namesArray, kind2, propertyName, type2);
        return new SuggestedNameInfo(namesArray){

            public void nameChosen(String name2) {
                if (type2 == null || !type2.isValid()) {
                    return;
                }
                JavaStatisticsManager.incVariableNameUseCount((String)name2, (VariableKind)kind2, (String)propertyName, (PsiType)type2);
            }
        };
    }

    @NonNls
    @NotNull
    private String changeIfNotIdentifier(@NotNull String name2) {
        if (!this.isIdentifier(name2)) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name2);
        }
        return name2;
    }

    private boolean isIdentifier(@NotNull String name2) {
        return PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name2, LanguageLevel.HIGHEST);
    }

    @NotNull
    private JavaCodeStyleSettings getJavaSettings() {
        return (JavaCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class);
    }

    private static class NamesByExprInfo {
        static final NamesByExprInfo EMPTY = new NamesByExprInfo(null, Collections.emptyList());
        private final String propertyName;
        private final Collection<String> names;

        private NamesByExprInfo(@Nullable String propertyName, @NotNull Collection<String> names2) {
            this.propertyName = propertyName;
            this.names = names2;
        }

        private NamesByExprInfo(@NotNull String propertyName) {
            this(propertyName, Collections.singletonList(propertyName));
        }

        private NamesByExprInfo(@Nullable String propertyName, String ... names2) {
            this(propertyName, propertyName == null ? Arrays.asList(names2) : ContainerUtil.prepend(Arrays.asList(names2), (Object[])new String[]{propertyName}));
        }
    }
}

