/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiJavaModuleReferenceImpl
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement>
implements PsiJavaModuleReference {
    public PsiJavaModuleReferenceImpl(@NotNull PsiJavaModuleReferenceElement element) {
        super((PsiElement)element, new TextRange(0, element.getTextLength()), false);
    }

    @NotNull
    public String getCanonicalText() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
    }

    public PsiJavaModule resolve() {
        return (PsiJavaModule)super.resolve();
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        return ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, Resolver.INSTANCE, false, incompleteCode);
    }

    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement element = (PsiJavaModuleReferenceElement)this.getElement();
        if (element instanceof PsiCompiledElement) {
            throw new IncorrectOperationException(JavaPsiBundle.message((String)"psi.error.attempt.to.edit.class.file", (Object[])new Object[]{element.getContainingFile()}));
        }
        PsiJavaModuleReferenceElement newElement = PsiElementFactory.getInstance((Project)element.getProject()).createModuleReferenceFromText(newName, null);
        return element.replace((PsiElement)newElement);
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReferenceImpl> INSTANCE = new Resolver();

        private Resolver() {
        }

        public ResolveResult @NotNull [] resolve(@NotNull PsiJavaModuleReferenceImpl reference, boolean incompleteCode) {
            PsiJavaModule module;
            PsiJavaModuleReferenceElement refElement = (PsiJavaModuleReferenceElement)reference.getElement();
            PsiFile file = refElement.getContainingFile();
            String moduleName = reference.getCanonicalText();
            if (file instanceof PsiJavaFile && (module = ((PsiJavaFile)file).getModuleDeclaration()) != null && module.getName().equals(moduleName)) {
                return new ResolveResult[]{new PsiElementResolveResult((PsiElement)module)};
            }
            boolean global = incompleteCode || refElement.getParent() instanceof PsiPackageAccessibilityStatement;
            Project project = file.getProject();
            GlobalSearchScope scope = global ? GlobalSearchScope.allScope((Project)project) : file.getResolveScope();
            Collection modules = JavaPsiFacade.getInstance((Project)project).findModules(moduleName, scope);
            if (!modules.isEmpty()) {
                ResolveResult[] result = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module2 : modules) {
                    result[i++] = new PsiElementResolveResult((PsiElement)module2);
                }
                return result;
            }
            return ResolveResult.EMPTY_ARRAY;
        }
    }
}

