/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiEnumConstantImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiEnumConstant {
    private static final Logger LOG = Logger.getInstance(PsiEnumConstantImpl.class);
    private final MyReference myReference = new MyReference();

    public PsiEnumConstantImpl(PsiFieldStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ENUM_CONSTANT);
    }

    public PsiEnumConstantImpl(ASTNode node) {
        super(node);
    }

    public String toString() {
        return "PsiEnumConstant:" + this.getName();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitEnumConstant((PsiEnumConstant)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.calcTreeElement().findChildByRoleAsPsiElement(73);
    }

    public PsiEnumConstantInitializer getInitializingClass() {
        return (PsiEnumConstantInitializer)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    @NotNull
    public PsiEnumConstantInitializer getOrCreateInitializingClass() {
        PsiEnumConstantInitializer initializingClass2 = this.getInitializingClass();
        if (initializingClass2 != null) {
            return initializingClass2;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiEnumConstantInitializer initializer = factory.createEnumConstantFromText("foo{}", null).getInitializingClass();
        LOG.assertTrue(initializer != null);
        PsiExpressionList argumentList = this.getArgumentList();
        if (argumentList != null) {
            return (PsiEnumConstantInitializer)this.addAfter((PsiElement)initializer, (PsiElement)argumentList);
        }
        return (PsiEnumConstantInitializer)this.addAfter((PsiElement)initializer, (PsiElement)this.getNameIdentifier());
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return "public".equals(name2) || "static".equals(name2) || "final".equals(name2);
    }

    @NotNull
    public PsiType getType() {
        return JavaPsiFacade.getElementFactory((Project)this.getProject()).createType(this.getContainingClass());
    }

    public PsiTypeElement getTypeElement() {
        return null;
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return true;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public Object computeConstantValue() {
        return this;
    }

    public PsiMethod resolveMethod() {
        return (PsiMethod)this.resolveMethodGenerics().getElement();
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        return (JavaResolveResult)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiClass containingClass = this.getContainingClass();
            LOG.assertTrue(containingClass != null);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
            return new CachedValueProvider.Result((Object)facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), (PsiElement)this), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.calcTreeElement().findChildByRoleAsPsiElement(9);
    }

    @NotNull
    public String getName() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return this.getNameIdentifier().getText();
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name2);
        return this;
    }

    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.calcTreeElement().findChildByRoleAsPsiElement(7);
    }

    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    public PsiReference getReference() {
        return this.myReference;
    }

    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.FIELD_ICON, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo((PsiField)this, another);
    }

    private class MyReference
    implements PsiJavaReference {
        private MyReference() {
        }

        @NotNull
        public PsiElement getElement() {
            return PsiEnumConstantImpl.this;
        }

        @NotNull
        public TextRange getRangeInElement() {
            PsiIdentifier nameIdentifier = PsiEnumConstantImpl.this.getNameIdentifier();
            int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
            if (Registry.is((String)"java.empty.enum.constructor.ref")) {
                return TextRange.from((int)(startOffsetInParent + nameIdentifier.getTextLength()), (int)0);
            }
            return TextRange.from((int)startOffsetInParent, (int)nameIdentifier.getTextLength());
        }

        public boolean isSoft() {
            return false;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            throw new IncorrectOperationException("Invalid operation");
        }

        public void processVariants(@NotNull PsiScopeProcessor processor2) {
        }

        public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)PsiEnumConstantImpl.this.getProject());
            PsiClassType type2 = facade.getElementFactory().createType(PsiEnumConstantImpl.this.getContainingClass());
            return facade.getResolveHelper().multiResolveConstructor(type2, PsiEnumConstantImpl.this.getArgumentList(), this.getElement());
        }

        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            JavaResolveResult[] results = this.multiResolve(incompleteCode);
            if (results.length == 1) {
                return results[0];
            }
            return JavaResolveResult.EMPTY;
        }

        public PsiElement resolve() {
            return this.advancedResolve(false).getElement();
        }

        @NotNull
        public String getCanonicalText() {
            return PsiEnumConstantImpl.this.getContainingClass().getName();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && ((PsiMethod)element).getContainingClass() == PsiEnumConstantImpl.this.getContainingClass() && PsiEnumConstantImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }
    }
}

