/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PackageAccessibilityStatementElement
extends CompositeElement {
    public PackageAccessibilityStatementElement(@NotNull IElementType type2) {
        super(type2);
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first == last && first.getElementType() == JavaElementType.MODULE_REFERENCE && anchor == null) {
            TreeElement lastChild;
            TreeElement addAfter = lastChild = this.getLastChildNode();
            if (lastChild.getElementType() == JavaTokenType.SEMICOLON || lastChild.getElementType() == TokenType.ERROR_ELEMENT) {
                addAfter = lastChild.getTreePrev();
                lastChild = PsiImplUtil.skipWhitespaceAndCommentsBack((ASTNode)addAfter);
            }
            if (lastChild != null) {
                CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)this);
                if (lastChild.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
                    LeafElement to = Factory.createSingleLeafElement((IElementType)JavaTokenType.TO_KEYWORD, (CharSequence)"to", (CharTable)charTable, (PsiManager)this.getManager());
                    anchor = super.addInternal((TreeElement)to, (ASTNode)to, (ASTNode)addAfter, Boolean.FALSE);
                    before = Boolean.FALSE;
                } else if (lastChild.getElementType() == JavaElementType.MODULE_REFERENCE) {
                    LeafElement comma = Factory.createSingleLeafElement((IElementType)JavaTokenType.COMMA, (CharSequence)",", (CharTable)charTable, (PsiManager)this.getManager());
                    anchor = super.addInternal((TreeElement)comma, (ASTNode)comma, (ASTNode)addAfter, Boolean.FALSE);
                    before = Boolean.FALSE;
                }
            }
        }
        return super.addInternal(first, last, anchor, before);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child.getElementType() == JavaElementType.MODULE_REFERENCE) {
            ASTNode comma = PackageAccessibilityStatementElement.findNearestComma(child);
            if (comma != null) {
                super.deleteChildInternal(comma);
            } else {
                ASTNode toKeyword = this.findChildByType(JavaTokenType.TO_KEYWORD);
                if (toKeyword != null) {
                    super.deleteChildInternal(toKeyword);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    private static ASTNode findNearestComma(ASTNode child) {
        ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
        if (next != null && next.getElementType() == JavaTokenType.COMMA) {
            return next;
        }
        ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            return prev;
        }
        return null;
    }
}

