/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final Ref<Pair<Long, Interner<PsiMember>>> myInterner = Ref.create();

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        this.myClass = aClass;
    }

    public PsiMethod @NotNull [] getConstructors() {
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, PsiImplUtil::getConstructors));
    }

    public PsiField @NotNull [] getFields() {
        return (PsiField[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcFields()));
    }

    public PsiMethod @NotNull [] getMethods() {
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcMethods()));
    }

    public PsiClass @NotNull [] getInnerClasses() {
        return (PsiClass[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcInnerClasses()));
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        return (PsiRecordComponent[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcRecordComponents()));
    }

    @Nullable
    public PsiField findFieldByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name2, true);
        }
        return (PsiField)((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.getFieldsMap())).get(name2);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findMethodsByName(this.myClass, name2, true);
        }
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])ObjectUtils.notNull(((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.getMethodsMap())).get(name2), (Object)PsiMethod.EMPTY_ARRAY));
    }

    @Nullable
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name2, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.getInnerClassesMap())).get(name2);
    }

    @Nullable
    PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? (PsiMethod)this.internMember((PsiMember)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, ClassInnerStuffCache::makeValuesMethod)) : null;
    }

    @Nullable
    private PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? (PsiMethod)this.internMember((PsiMember)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, ClassInnerStuffCache::makeValueOfMethod)) : null;
    }

    private boolean isAnonymousClass() {
        return this.myClass.getName() == null || this.myClass instanceof PsiAnonymousClass;
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    private PsiField @NotNull [] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List ext = this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class, null));
        return (PsiField[])ArrayUtil.mergeCollections(own, ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
    }

    @NotNull
    private <T extends PsiMember> List<T> internMembers(List<T> members) {
        return ContainerUtil.map(members, this::internMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PsiMember> T internMember(T m) {
        if (m == null) {
            return null;
        }
        long modCount = this.myClass.getManager().getModificationTracker().getModificationCount();
        Ref<Pair<Long, Interner<PsiMember>>> ref = this.myInterner;
        synchronized (ref) {
            Pair pair2 = (Pair)this.myInterner.get();
            if (pair2 == null || (Long)pair2.first != modCount) {
                pair2 = Pair.create((Object)modCount, (Object)Interner.createWeakInterner());
                this.myInterner.set((Object)pair2);
            }
            return (T)((PsiMember)((Interner)pair2.second).intern(m));
        }
    }

    private PsiMethod @NotNull [] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List ext = this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class, null));
        if (this.myClass.isEnum()) {
            ext = new ArrayList(ext);
            ContainerUtil.addIfNotNull(ext, (Object)this.getValuesMethod());
            ContainerUtil.addIfNotNull(ext, (Object)this.getValueOfMethod());
        }
        return (PsiMethod[])ArrayUtil.mergeCollections(own, ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    private PsiClass @NotNull [] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List ext = this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class, null));
        return (PsiClass[])ArrayUtil.mergeCollections(own, ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
    }

    private PsiRecordComponent @NotNull [] calcRecordComponents() {
        PsiRecordHeader header = this.myClass.getRecordHeader();
        return header == null ? PsiRecordComponent.EMPTY_ARRAY : header.getRecordComponents();
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        THashMap cachedFields = new THashMap();
        for (PsiField field : this.myClass.getOwnFields()) {
            String name2 = field.getName();
            if (cachedFields.containsKey(name2)) continue;
            cachedFields.put(name2, field);
        }
        return ConcurrentFactoryMap.createMap(arg_0 -> this.lambda$getFieldsMap$7((Map)cachedFields, arg_0));
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        List<PsiMethod> ownMethods = this.myClass.getOwnMethods();
        return ConcurrentFactoryMap.createMap(name2 -> (PsiMethod[])JBIterable.from((Iterable)ownMethods).filter(m -> name2.equals(m.getName())).append((Object)("values".equals(name2) ? this.getValuesMethod() : null)).append((Object)("valueOf".equals(name2) ? this.getValueOfMethod() : null)).append(this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class, (String)name2))).toArray((Object[])PsiMethod.EMPTY_ARRAY));
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : this.myClass.getOwnInnerClasses()) {
            String name2 = psiClass.getName();
            if (name2 == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error((Object)psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name2)) continue;
            cachedInners.put(name2, psiClass);
        }
        return ConcurrentFactoryMap.createMap(arg_0 -> this.lambda$getInnerClassesMap$10((Map)cachedInners, arg_0));
    }

    private static PsiMethod makeValuesMethod(PsiExtensibleClass enumClass) {
        return new EnumSyntheticMethod(enumClass, "public static " + enumClass.getName() + "[] values() { }");
    }

    private static PsiMethod makeValueOfMethod(PsiExtensibleClass enumClass) {
        return new EnumSyntheticMethod(enumClass, "public static " + enumClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void dropCaches() {
    }

    private /* synthetic */ PsiClass lambda$getInnerClassesMap$10(Map cachedInners, String name2) {
        PsiClass result = (PsiClass)cachedInners.get(name2);
        return result != null ? result : (PsiClass)this.internMember((PsiMember)ContainerUtil.getFirstItem((List)PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class, (String)name2)));
    }

    private /* synthetic */ PsiField lambda$getFieldsMap$7(Map cachedFields, String name2) {
        PsiField result = (PsiField)cachedFields.get(name2);
        return result != null ? result : (PsiField)this.internMember((PsiMember)ContainerUtil.getFirstItem((List)PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class, (String)name2)));
    }

    private static class EnumSyntheticMethod
    extends LightMethod
    implements SyntheticElement {
        private final PsiClass myClass;
        private final String myText;

        EnumSyntheticMethod(@NotNull PsiClass enumClass, @NotNull String text2) {
            super(enumClass.getManager(), JavaPsiFacade.getElementFactory((Project)enumClass.getProject()).createMethodFromText(text2, (PsiElement)enumClass), enumClass);
            this.myClass = enumClass;
            this.myText = text2;
        }

        public int getTextOffset() {
            return this.myClass.getTextOffset();
        }

        public boolean equals(Object another) {
            return this == another || another instanceof EnumSyntheticMethod && this.myClass.equals(((EnumSyntheticMethod)((Object)another)).myClass) && this.myText.equals(((EnumSyntheticMethod)((Object)another)).myText);
        }

        public int hashCode() {
            return Objects.hash(this.myText, this.myClass);
        }
    }
}

