/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MethodTextOccurrenceProcessor
extends RequestResultProcessor {
    private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
    private final PsiMethod[] myMethods;
    protected final PsiClass myContainingClass;
    private final boolean myStrictSignatureSearch;

    public MethodTextOccurrenceProcessor(@NotNull PsiClass aClass, boolean strictSignatureSearch, PsiMethod ... methods) {
        super(new Object[]{strictSignatureSearch, Arrays.asList(methods)});
        this.myMethods = methods;
        this.myContainingClass = aClass;
        this.myStrictSignatureSearch = strictSignatureSearch;
    }

    public final boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        for (PsiReference ref : ourReferenceService.getReferences(element, new PsiReferenceService.Hints((PsiElement)this.myMethods[0], Integer.valueOf(offsetInElement)))) {
            if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || this.processReference(consumer, ref)) continue;
            return false;
        }
        return true;
    }

    private boolean processReference(Processor<? super PsiReference> consumer, PsiReference ref) {
        for (PsiMethod method : this.myMethods) {
            if (!method.isValid()) continue;
            if (ref instanceof ResolvingHint && !((ResolvingHint)ref).canResolveTo(PsiMethod.class)) {
                return true;
            }
            if (ref.isReferenceTo((PsiElement)method)) {
                return consumer.process((Object)ref);
            }
            if (this.processInexactReference(ref, ref.resolve(), method, consumer)) continue;
            return false;
        }
        return true;
    }

    protected boolean processInexactReference(PsiReference ref, PsiElement refElement, PsiMethod method, Processor<? super PsiReference> consumer) {
        if (refElement instanceof PsiMethod) {
            PsiManager manager;
            MethodSignature refSignature;
            MethodSignature superSignature;
            PsiSubstitutor substitutor;
            PsiMethod refMethod = (PsiMethod)refElement;
            PsiClass refMethodClass = refMethod.getContainingClass();
            if (refMethodClass == null) {
                return true;
            }
            if (!refMethod.hasModifierProperty("static") && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)this.myContainingClass, (PsiClass)refMethodClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null && MethodSignatureUtil.isSubsignature((MethodSignature)(superSignature = method.getSignature(substitutor)), (MethodSignature)(refSignature = refMethod.getSignature(PsiSubstitutor.EMPTY))) && !consumer.process((Object)ref)) {
                return false;
            }
            if (!this.myStrictSignatureSearch && (manager = method.getManager()).areElementsEquivalent((PsiElement)refMethodClass, (PsiElement)this.myContainingClass)) {
                return consumer.process((Object)ref);
            }
        }
        return true;
    }
}

