/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(JavaFunctionalExpressionSearcher.class);
    public static final int SMART_SEARCH_THRESHOLD = 5;

    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        Session session = (Session)ReadAction.compute(() -> new Session(p, consumer));
        session.processResults();
        if (session.filesLookedInside.size() > 0 && LOG.isDebugEnabled()) {
            LOG.debug(session.toString());
        }
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull Session session) {
        ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
        ReadAction.run(() -> {
            PsiClass aClass = session.elementToSearch;
            if (!aClass.isValid() || !aClass.isInterface()) {
                return;
            }
            Project project = aClass.getProject();
            if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasJava8Modules(project)) {
                return;
            }
            HashSet visited = new HashSet();
            JavaFunctionalExpressionSearcher.processSubInterfaces(aClass, visited);
            for (PsiClass samClass : visited) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass((PsiClass)samClass) || (samType = (saMethod = Objects.requireNonNull(LambdaUtil.getFunctionalInterfaceMethod((PsiClass)samClass))).getReturnType()) == null) continue;
                SearchScope scope = samClass.getUseScope().intersectWith(session.scope);
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)scope, (Project)project)));
            }
        });
        return descriptors;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(@NotNull List<? extends SamDescriptor> descriptors, @NotNull Collection<? extends VirtualFile> candidateFiles, @NotNull Project project) {
        GlobalSearchScope candidateFilesScope = GlobalSearchScope.filesScope((Project)project, candidateFiles);
        return JBIterable.from(descriptors).flatMap(descriptor -> ((SamDescriptor)descriptor).getMostLikelyFiles(candidateFilesScope)).toSet();
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(@NotNull List<? extends SamDescriptor> descriptors) {
        MultiMap result = MultiMap.createLinkedSet();
        descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> {
            for (SamDescriptor descriptor : descriptors) {
                JavaSourceFilterScope scope = new JavaSourceFilterScope(descriptor.effectiveUseScope);
                for (FunctionalExpressionKey key2 : descriptor.keys) {
                    FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, (Object)key2, null, (file, infos) -> {
                        result.putValues((Object)file, (Collection)ContainerUtil.map((Collection)infos, entry -> entry.occurrence));
                        return true;
                    }, (GlobalSearchScope)scope);
                }
            }
        });
        LOG.debug("Found " + result.values().size() + " fun-expressions in " + result.keySet().size() + " files");
        return result;
    }

    private static void processOffsets(@NotNull List<? extends SamDescriptor> descriptors, @NotNull Session session) {
        if (descriptors.isEmpty()) {
            return;
        }
        List samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        if (allCandidates.isEmpty()) {
            return;
        }
        Set allFiles = allCandidates.keySet();
        session.filesConsidered.addAndGet(allFiles.size());
        Set<VirtualFile> filesFirst = JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors, allFiles, session.project);
        Processor vFileProcessor = vFile -> {
            Collection occurrences = allCandidates.get(vFile);
            session.contextsConsidered.addAndGet(occurrences.size());
            Map<FunExprOccurrence, Confidence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, occurrences, session.project);
            if (!toLoad.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("To load " + vFile.getPath() + " with values: " + toLoad);
                }
                session.filesLookedInside.add(vFile);
                return JavaFunctionalExpressionSearcher.processFile(descriptors, vFile, toLoad, session);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<VirtualFile>(filesFirst), ProgressIndicatorProvider.getGlobalProgressIndicator(), vFileProcessor)) {
            return;
        }
        allFiles.removeAll(filesFirst);
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(allFiles), ProgressIndicatorProvider.getGlobalProgressIndicator(), vFileProcessor);
    }

    @NotNull
    private static Map<FunExprOccurrence, Confidence> filterInapplicable(@NotNull List<? extends PsiClass> samClasses, @NotNull VirtualFile vFile, @NotNull Collection<? extends FunExprOccurrence> occurrences, @NotNull Project project) {
        HashMap<FunExprOccurrence, Confidence> map2 = new HashMap<FunExprOccurrence, Confidence>();
        DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            for (FunExprOccurrence occurrence : occurrences) {
                ThreeState result = occurrence.checkHasTypeLight(samClasses, vFile);
                if (result == ThreeState.NO) continue;
                map2.put(occurrence, result == ThreeState.YES ? Confidence.sure : Confidence.needsCheck);
            }
        });
        return map2;
    }

    private static boolean processFile(@NotNull List<? extends SamDescriptor> descriptors, @NotNull VirtualFile vFile, @NotNull Map<FunExprOccurrence, Confidence> occurrences, @NotNull Session session) {
        return (Boolean)descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> {
            PsiManager manager = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager();
            PsiFile file = manager.findFile(vFile);
            if (!(file instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + file + "; " + vFile);
                return true;
            }
            HashMap<TextRange, PsiFile> fragmentCache = new HashMap<TextRange, PsiFile>();
            @NotNull List data = ContainerUtil.flatten(FileBasedIndex.getInstance().getFileData(JavaFunctionalExpressionIndex.INDEX_ID, vFile, manager.getProject()).values());
            for (JavaFunctionalExpressionIndex.IndexEntry entry : data) {
                PsiFunctionalExpression toCheck;
                PsiFunctionalExpression expression2;
                Confidence confidence = (Confidence)((Object)((Object)occurrences.get(entry.occurrence)));
                if (confidence == null) continue;
                (confidence == Confidence.sure ? session.sureExprsAfterLightCheck : session.exprsToHeavyCheck).incrementAndGet();
                int offset = entry.exprStart;
                boolean useAST = ((PsiFileEx)file).isContentsLoaded();
                PsiFunctionalExpression psiFunctionalExpression = expression2 = useAST ? JavaFunctionalExpressionSearcher.findPsiByAST(file, offset) : JavaFunctionalExpressionSearcher.findPsiByStubs(file, entry.exprIndex);
                if (expression2 == null) {
                    LOG.error("Fun expression not found in " + file + " at " + offset);
                    continue;
                }
                if (confidence == Confidence.needsCheck && !JavaFunctionalExpressionSearcher.hasType(descriptors, toCheck = useAST ? expression2 : JavaFunctionalExpressionSearcher.getNonPhysicalCopy(fragmentCache, entry, expression2)) || session.consumer.process((Object)expression2)) continue;
                return false;
            }
            return true;
        });
    }

    @Nullable
    private static PsiFunctionalExpression findPsiByAST(PsiFile file, int offset) {
        PsiFunctionalExpression expression2 = (PsiFunctionalExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiFunctionalExpression.class, (boolean)false);
        if (expression2 == null || expression2.getTextRange().getStartOffset() != offset) {
            return null;
        }
        return expression2;
    }

    private static PsiFunctionalExpression findPsiByStubs(PsiFile file, int index) {
        StubbedSpine spine = ((PsiFileWithStubSupport)file).getStubbedSpine();
        int funExprIndex = 0;
        for (int i = 0; i < spine.getStubCount(); ++i) {
            IElementType type2 = spine.getStubType(i);
            if (type2 != JavaStubElementTypes.LAMBDA_EXPRESSION && type2 != JavaStubElementTypes.METHOD_REF_EXPRESSION) continue;
            if (funExprIndex == index) {
                return (PsiFunctionalExpression)spine.getStubPsi(i);
            }
            ++funExprIndex;
        }
        return null;
    }

    @NotNull
    private static PsiFunctionalExpression getNonPhysicalCopy(Map<TextRange, PsiFile> fragmentCache, JavaFunctionalExpressionIndex.IndexEntry entry, PsiFunctionalExpression expression2) {
        try {
            PsiMember member = (PsiMember)Objects.requireNonNull(PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)expression2, PsiMember.class));
            PsiFile fragment = fragmentCache.computeIfAbsent(TextRange.create((int)entry.contextStart, (int)entry.contextEnd), range -> JavaFunctionalExpressionSearcher.createMemberCopyFromText(member, range));
            return Objects.requireNonNull(JavaFunctionalExpressionSearcher.findPsiByAST(fragment, entry.exprStart - entry.contextStart));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            FileBasedIndex.getInstance().requestReindex(expression2.getContainingFile().getViewProvider().getVirtualFile());
            LOG.error(e);
            return expression2;
        }
    }

    private static PsiFile createMemberCopyFromText(@NotNull PsiMember member, @NotNull TextRange memberRange) {
        PsiFile file = member.getContainingFile();
        String contextText = memberRange.subSequence(file.getViewProvider().getContents()).toString();
        Project project = file.getProject();
        return member instanceof PsiEnumConstant ? PsiElementFactory.getInstance((Project)project).createEnumConstantFromText(contextText, (PsiElement)member).getContainingFile() : JavaCodeFragmentFactory.getInstance((Project)project).createMemberCodeFragment(contextText, (PsiElement)member, false);
    }

    private static boolean hasType(@NotNull List<? extends SamDescriptor> descriptors, @NotNull PsiFunctionalExpression expression2) {
        ThreeState approximate = JavaFunctionalExpressionSearcher.approximateHasType(expression2, ContainerUtil.map(descriptors, d -> d.samClass));
        if (approximate != ThreeState.UNSURE) {
            return approximate == ThreeState.YES;
        }
        PsiClass actualClass = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)expression2);
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)d.samClass, (boolean)true));
    }

    private static ThreeState approximateHasType(@NotNull PsiFunctionalExpression expression2, @NotNull List<? extends PsiClass> samClasses) {
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression2);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                List<PsiMethod> methods;
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> list = methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null ? ThreeState.UNSURE : (methods.isEmpty() ? ThreeState.NO : ThreeState.merge((Iterable)JBIterable.from(methods).map(m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses))));
            }
        }
        return ThreeState.UNSURE;
    }

    private static boolean hasJava8Modules(@NotNull Project project) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project).isAtLeast(LanguageLevel.JDK_1_8);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || !((level = extension.getLanguageLevel()) == null ? projectLevelIsHigh : level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            return true;
        }
        return false;
    }

    private static void processSubInterfaces(@NotNull PsiClass base, @NotNull Set<? super PsiClass> visited) {
        if (!visited.add((PsiClass)base)) {
            return;
        }
        DirectClassInheritorsSearch.search((PsiClass)base).forEach(candidate -> {
            if (candidate.isInterface()) {
                JavaFunctionalExpressionSearcher.processSubInterfaces(candidate, visited);
            }
            return true;
        });
    }

    private static boolean performSearchUsingCompilerIndices(@NotNull List<? extends SamDescriptor> descriptors, @NotNull GlobalSearchScope searchScope, @NotNull Project project, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        if (compilerReferenceService == null) {
            return true;
        }
        for (SamDescriptor samDescriptor : descriptors) {
            CompilerDirectHierarchyInfo info = compilerReferenceService.getFunExpressions((PsiNamedElement)samDescriptor.samClass, searchScope, (FileType)JavaFileType.INSTANCE);
            if (info == null || JavaFunctionalExpressionSearcher.processFunctionalExpressions(info, samDescriptor, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processFunctionalExpressions(@NotNull CompilerDirectHierarchyInfo funExprInfo, @NotNull SamDescriptor descriptor, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        if (!ContainerUtil.process(funExprInfo.getHierarchyChildren().iterator(), fe -> consumer.process((Object)((PsiFunctionalExpression)fe)))) {
            return false;
        }
        GlobalSearchScope dirtyScope = funExprInfo.getDirtyScope();
        descriptor.effectiveUseScope = descriptor.effectiveUseScope.intersectWith(dirtyScope);
        return true;
    }

    @VisibleForTesting
    public static class Session {
        private final Processor<? super PsiFunctionalExpression> consumer;
        private final Project project;
        private final SearchScope scope;
        private final PsiManager psiManager;
        private final PsiClass elementToSearch;
        private final AtomicInteger filesConsidered = new AtomicInteger();
        private final AtomicInteger contextsConsidered = new AtomicInteger();
        private final AtomicInteger sureExprsAfterLightCheck = new AtomicInteger();
        private final AtomicInteger exprsToHeavyCheck = new AtomicInteger();
        private final Set<VirtualFile> filesLookedInside = ContainerUtil.newConcurrentSet();

        public Session(@NotNull FunctionalExpressionSearch.SearchParameters parameters2, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
            this.consumer = consumer;
            this.elementToSearch = parameters2.getElementToSearch();
            this.project = this.elementToSearch.getProject();
            this.psiManager = PsiManager.getInstance((Project)this.project);
            this.scope = parameters2.getEffectiveSearchScope();
        }

        public Set<VirtualFile> getFilesLookedInside() {
            return this.filesLookedInside;
        }

        public void processResults() {
            List descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(this);
            if (this.scope instanceof GlobalSearchScope && !JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptors, (GlobalSearchScope)this.scope, this.project, (Processor<? super PsiFunctionalExpression>)this.consumer)) {
                return;
            }
            this.psiManager.startBatchFilesProcessingMode();
            try {
                JavaFunctionalExpressionSearcher.processOffsets(descriptors, this);
            }
            finally {
                this.psiManager.finishBatchFilesProcessingMode();
            }
        }

        public String getStatistics() {
            return "filesConsidered=" + this.filesConsidered + ", contextsConsidered=" + this.contextsConsidered + ", sureExprsAfterLightCheck=" + this.sureExprsAfterLightCheck + ", exprsToHeavyCheck=" + this.exprsToHeavyCheck + ", filesLookedInside=" + this.filesLookedInside.size();
        }
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;
        final DumbService dumbService;
        final List<FunctionalExpressionKey> keys;
        GlobalSearchScope effectiveUseScope;

        SamDescriptor(@NotNull PsiClass samClass, @NotNull PsiMethod samMethod, @NotNull PsiType samType, @NotNull GlobalSearchScope useScope) {
            this.samClass = samClass;
            this.effectiveUseScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiType.VOID.equals((Object)samType);
            this.dumbService = DumbService.getInstance((Project)samClass.getProject());
            this.keys = this.generateKeys();
        }

        @NotNull
        private List<FunctionalExpressionKey> generateKeys() {
            String name2;
            String string = name2 = this.samClass.isValid() ? this.samClass.getName() : null;
            if (name2 == null) {
                return Collections.emptyList();
            }
            ArrayList<FunctionalExpressionKey> result = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{Objects.requireNonNull(name2), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            return result;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles(@NotNull GlobalSearchScope searchScope) {
            LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
            this.dumbService.runReadActionInSmartMode(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className2 = this.samClass.getName();
                Project project = this.samClass.getProject();
                if (className2 == null) {
                    return;
                }
                LinkedHashSet likelyNames = ContainerUtil.newLinkedHashSet((Object[])new String[]{className2});
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), (Object)className2, project, this.effectiveUseScope, PsiMethod.class, method -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method.getName());
                    return true;
                });
                PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)project);
                Processor processor2 = Processors.cancelableCollectProcessor((Collection)files);
                for (String word : likelyNames) {
                    helper.processCandidateFilesForText(searchScope, (short)1, true, word, processor2);
                }
            });
            return files;
        }
    }

    private static enum Confidence {
        sure,
        needsCheck;

    }
}

