/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightTypeElement
extends LightElement
implements PsiTypeElement {
    private final PsiType myType;

    public LightTypeElement(PsiManager manager, PsiType type2) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myType = type2 = PsiUtil.convertAnonymousToBaseType((PsiType)type2);
    }

    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    public String getText() {
        return this.myType.getPresentableText(true);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiElement copy() {
        return new LightTypeElement(this.myManager, this.myType);
    }

    @NotNull
    public PsiType getType() {
        return this.myType;
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    public boolean isValid() {
        return this.myType.isValid();
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        return this.myType.getAnnotations();
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        return this.myType.findAnnotation(qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        throw new IncorrectOperationException();
    }

    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        return this.getAnnotations();
    }
}

