/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightRecordField
extends LightField
implements LightRecordMember {
    @NotNull
    private final PsiRecordComponent myRecordComponent;

    public LightRecordField(@NotNull PsiManager manager, @NotNull PsiField field, @NotNull PsiClass containingClass, @NotNull PsiRecordComponent component) {
        super(manager, field, containingClass);
        this.myRecordComponent = component;
    }

    @Override
    @NotNull
    public PsiRecordComponent getRecordComponent() {
        return this.myRecordComponent;
    }

    public int getTextOffset() {
        return this.myRecordComponent.getTextOffset();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myRecordComponent.getNavigationElement();
    }

    public boolean isWritable() {
        return true;
    }

    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return containingClass.getContainingFile();
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (DumbService.isDumb((Project)this.myRecordComponent.getProject())) {
            return this.myRecordComponent.getType();
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiType type2 = this.myRecordComponent.getType().annotate(() -> (PsiAnnotation[])Arrays.stream(this.myRecordComponent.getAnnotations()).filter(LightRecordField::hasApplicableAnnotationTarget).toArray(PsiAnnotation[]::new));
            return CachedValueProvider.Result.create((Object)type2, (Object[])new Object[]{this});
        });
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        return this.getType().getAnnotations();
    }

    public boolean hasAnnotation(@NotNull String fqn) {
        PsiType type2 = this.getType();
        return type2.hasAnnotation(fqn);
    }

    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        return this.getType().findAnnotation(fqn);
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.FIELD_ICON, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        if (BitUtil.isSet((int)flags, (int)1)) {
            VisibilityIcons.setVisibilityIcon((int)1, (RowIcon)baseIcon);
        }
        return baseIcon;
    }

    public PsiElement getContext() {
        return this.getContainingClass();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope((PsiElement)Objects.requireNonNull(this.getContainingClass()));
    }

    private static boolean hasApplicableAnnotationTarget(PsiAnnotation annotation) {
        return AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE, PsiAnnotation.TargetType.FIELD}) != null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof LightRecordField && this.myRecordComponent.equals(((LightRecordField)o).myRecordComponent);
    }

    public int hashCode() {
        return Objects.hash(this.myRecordComponent);
    }
}

