/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class JavaSourceModuleNameIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"java.source.module.name");
    private final FileType myManifestFileType = FileTypeRegistry.getInstance().getFileTypeByExtension("MF");
    private final FileBasedIndex.InputFilter myFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{this.myManifestFileType}){

        public boolean acceptInput(@NotNull VirtualFile f) {
            return f.isInLocalFileSystem();
        }
    };
    private final DataIndexer<String, Void, FileContent> myIndexer = data -> {
        try {
            String name2 = new Manifest(new ByteArrayInputStream(data.getContent())).getMainAttributes().getValue("Automatic-Module-Name");
            if (name2 != null) {
                return Collections.singletonMap(name2, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyMap();
    };

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myFilter;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        return Collections.singleton(JavaClassFileType.INSTANCE);
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)moduleName, (GlobalSearchScope)new JavaAutoModuleFilterScope(scope));
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }
}

