/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleNameIndex
extends StringStubIndexExtension<PsiJavaModule> {
    private static final JavaModuleNameIndex ourInstance = new JavaModuleNameIndex();
    private static final Key<CachedValue<Boolean>> MULTI_RELEASE_KEY = Key.create((String)"jar.multi.release.key");

    public static JavaModuleNameIndex getInstance() {
        return ourInstance;
    }

    public int getVersion() {
        return super.getVersion() + 2;
    }

    @NotNull
    public StubIndexKey<String, PsiJavaModule> getKey() {
        return JavaStubIndexKeys.MODULE_NAMES;
    }

    public Collection<PsiJavaModule> get(@NotNull String name2, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules = StubIndex.getElements(this.getKey(), (Object)name2, (Project)project, (GlobalSearchScope)new JavaSourceFilterScope(scope, true), PsiJavaModule.class);
        if (modules.size() > 1) {
            modules = JavaModuleNameIndex.filterVersions(project, modules);
        }
        return modules;
    }

    private static Collection<PsiJavaModule> filterVersions(Project project, Collection<PsiJavaModule> modules) {
        HashSet<VirtualFile> filter = new HashSet<VirtualFile>();
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        for (PsiJavaModule module : modules) {
            VirtualFile root = index.getClassRootForFile(module.getContainingFile().getVirtualFile());
            if (root == null) continue;
            List<VirtualFile> files = JavaModuleNameIndex.descriptorFiles(root, false, false);
            VirtualFile main = (VirtualFile)ContainerUtil.getFirstItem(files);
            if (main != null && !root.equals(main.getParent()) && JavaModuleNameIndex.version(main.getParent()) < 9) {
                filter.add(main);
            }
            for (int i = 1; i < files.size(); ++i) {
                filter.add(files.get(i));
            }
        }
        if (!filter.isEmpty()) {
            modules = ContainerUtil.filter(modules, m -> !filter.contains(m.getContainingFile().getVirtualFile()));
        }
        return modules;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @Nullable
    public static VirtualFile descriptorFile(@NotNull VirtualFile root) {
        VirtualFile result = root.findChild("module-info.class");
        if (result == null) {
            result = (VirtualFile)ContainerUtil.getFirstItem(JavaModuleNameIndex.descriptorFiles(root, true, true));
        }
        return result;
    }

    private static List<VirtualFile> descriptorFiles(VirtualFile root, boolean checkAttribute, boolean filter) {
        SmartList results = new SmartList();
        ContainerUtil.addIfNotNull((Collection)results, (Object)root.findChild("module-info.class"));
        VirtualFile versionsDir = root.findFileByRelativePath("META-INF/versions");
        if (versionsDir != null && (!checkAttribute || JavaModuleNameIndex.isMultiReleaseJar(root))) {
            VirtualFile[] versions = versionsDir.getChildren();
            if (filter) {
                versions = (VirtualFile[])Stream.of(versions).filter(d -> JavaModuleNameIndex.version(d) >= 9).toArray(VirtualFile[]::new);
            }
            Arrays.sort(versions, JavaModuleNameIndex::compareVersions);
            for (VirtualFile version : versions) {
                ContainerUtil.addIfNotNull((Collection)results, (Object)version.findChild("module-info.class"));
            }
        }
        return results;
    }

    private static boolean isMultiReleaseJar(VirtualFile root) {
        VirtualFile manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) {
            return false;
        }
        CachedValue value2 = (CachedValue)manifest.getUserData(MULTI_RELEASE_KEY);
        if (value2 == null) {
            value2 = new CachedValueImpl(() -> {
                Boolean result = Boolean.FALSE;
                try (InputStream stream = manifest.getInputStream();){
                    result = Boolean.valueOf(new Manifest(stream).getMainAttributes().getValue(new Attributes.Name("Multi-Release")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{manifest});
            });
            manifest.putUserData(MULTI_RELEASE_KEY, (Object)value2);
        }
        return (Boolean)value2.getValue();
    }

    private static int version(VirtualFile dir) {
        try {
            return Integer.valueOf(dir.getName());
        }
        catch (RuntimeException ignore) {
            return Integer.MIN_VALUE;
        }
    }

    private static int compareVersions(VirtualFile dir1, VirtualFile dir2) {
        int v1 = JavaModuleNameIndex.version(dir1);
        int v2 = JavaModuleNameIndex.version(dir2);
        if (v1 < 9 && v2 < 9) {
            return 0;
        }
        if (v1 < 9) {
            return 1;
        }
        if (v2 < 9) {
            return -1;
        }
        return v1 - v2;
    }
}

