/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiLiteralStub
extends StubBase<PsiLiteralExpressionImpl> {
    @NotNull
    private final String myLiteralText;
    private volatile IElementType myLiteralType;

    public PsiLiteralStub(StubElement parent, @NotNull String literalText) {
        super(parent, (IStubElementType)JavaStubElementTypes.LITERAL_EXPRESSION);
        this.myLiteralText = literalText;
    }

    @NotNull
    public String getLiteralText() {
        return this.myLiteralText;
    }

    @NotNull
    public IElementType getLiteralType() {
        IElementType type2 = this.myLiteralType;
        if (type2 == null) {
            JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
            lexer.start(this.myLiteralText);
            this.myLiteralType = type2 = lexer.getTokenType();
            assert (type2 != null) : this.myLiteralText;
        }
        return type2;
    }
}

