/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final String[] myNames;
    private volatile PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type2, StubElement parent, String @NotNull [] names2) {
        super(parent, (IStubElementType)type2);
        ObjectUtils.assertAllElementsNotNull((Object[])names2);
        this.myNames = names2;
    }

    @Override
    public PsiClassType @NotNull [] getReferencedTypes() {
        PsiClassType[] types = this.myTypes;
        if (types == null) {
            this.myTypes = types = this.createTypes();
        }
        return (PsiClassType[])types.clone();
    }

    private PsiClassType @NotNull [] createTypes() {
        PsiClassType[] types = this.myNames.length == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = new PsiClassReferenceType((PsiJavaCodeReferenceElement)new ClsJavaCodeReferenceElementImpl(this.getPsi(), this.myNames[i]), null);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                try {
                    PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(this.myNames[i], (PsiElement)psi);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_NAME_KIND);
                    types[i] = factory.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type2 : types) {
                    if (type2 == null) continue;
                    newTypes[cnt++] = type2;
                }
                types = newTypes;
            }
        }
        return types;
    }

    @Override
    public String @NotNull [] getReferencedNames() {
        return (String[])this.myNames.clone();
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        return JavaClassReferenceListElementType.elementTypeToRole((IElementType)this.getStubType());
    }

    public String toString() {
        return "PsiRefListStub[" + this.getRole() + ':' + String.join((CharSequence)", ", this.myNames) + ']';
    }
}

