/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaLiteralExpressionElementType
extends JavaStubElementType<PsiLiteralStub, PsiLiteralExpression> {
    public JavaLiteralExpressionElementType() {
        super("LITERAL_EXPRESSION");
    }

    @Override
    public PsiLiteralExpression createPsi(@NotNull ASTNode node) {
        return new PsiLiteralExpressionImpl(node);
    }

    @NotNull
    public PsiLiteralStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        return new PsiLiteralStub(parentStub, RecordUtil.intern(tree.getCharTable(), (LighterASTNode)tree.getChildren(node).get(0)));
    }

    public PsiLiteralExpression createPsi(@NotNull PsiLiteralStub stub) {
        return new PsiLiteralExpressionImpl(stub);
    }

    public void serialize(@NotNull PsiLiteralStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeUTFFast(stub.getLiteralText());
    }

    @NotNull
    public PsiLiteralStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new PsiLiteralStub(parentStub, dataStream.readUTFFast());
    }

    public void indexStub(@NotNull PsiLiteralStub stub, @NotNull IndexSink sink) {
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new CompositeElement((IElementType)this);
    }

    public boolean shouldCreateStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        LighterASTNode parent = tree.getParent(node);
        return parent != null && parent.getTokenType() == JavaStubElementTypes.NAME_VALUE_PAIR;
    }

    public boolean shouldCreateStub(ASTNode node) {
        return node.getTreeParent().getElementType() == JavaStubElementTypes.NAME_VALUE_PAIR;
    }
}

