/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaBinaryPlusExpressionIndex
extends FileBasedIndexExtension<Boolean, PlusOffsets> {
    public static final ID<Boolean, PlusOffsets> INDEX_ID = ID.create((String)"java.binary.plus.expression");

    @NotNull
    public ID<Boolean, PlusOffsets> getName() {
        return INDEX_ID;
    }

    @NotNull
    public DataIndexer<Boolean, PlusOffsets, FileContent> getIndexer() {
        return inputData -> {
            TokenList tokens = JavaParserUtil.obtainTokens(inputData.getPsiFile());
            TIntArrayList result = new TIntArrayList();
            for (int i = 0; i < tokens.getTokenCount(); ++i) {
                if (!tokens.hasType(i, JavaTokenType.PLUS) || tokens.hasType(tokens.forwardWhile(i + 1, JavaParserUtil.WS_COMMENTS), ElementType.ALL_LITERALS) == tokens.hasType(tokens.backWhile(i - 1, JavaParserUtil.WS_COMMENTS), ElementType.ALL_LITERALS)) continue;
                result.add(tokens.getTokenStart(i));
            }
            if (result.isEmpty()) {
                return Collections.emptyMap();
            }
            THashMap resultMap = new THashMap();
            resultMap.put((Object)Boolean.TRUE, (Object)new PlusOffsets(result.toNativeArray()));
            return resultMap;
        };
    }

    @NotNull
    public KeyDescriptor<Boolean> getKeyDescriptor() {
        return BooleanDataDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<PlusOffsets> getValueExternalizer() {
        return new DataExternalizer<PlusOffsets>(){

            public void save(@NotNull DataOutput out, PlusOffsets value2) throws IOException {
                int[] offsets = value2.getOffsets();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)offsets.length);
                for (int i : offsets) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)i);
                }
            }

            public PlusOffsets read(@NotNull DataInput in) throws IOException {
                int[] result = new int[DataInputOutputUtil.readINT((DataInput)in)];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = DataInputOutputUtil.readINT((DataInput)in);
                }
                return new PlusOffsets(result);
            }
        };
    }

    public int getVersion() {
        return 4;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent(file);
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static class PlusOffsets {
        private final int[] offsets;

        PlusOffsets(int[] offsets) {
            this.offsets = offsets;
        }

        public int[] getOffsets() {
            return this.offsets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlusOffsets offsets1 = (PlusOffsets)o;
            return Arrays.equals(this.offsets, offsets1.offsets);
        }

        public int hashCode() {
            return Arrays.hashCode(this.offsets);
        }
    }
}

