/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FunExprOccurrence {
    private final int argIndex;
    private final List<? extends ReferenceChainLink> referenceContext;

    public FunExprOccurrence(int argIndex, List<? extends ReferenceChainLink> referenceContext) {
        this.argIndex = argIndex;
        this.referenceContext = referenceContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunExprOccurrence)) {
            return false;
        }
        FunExprOccurrence that = (FunExprOccurrence)o;
        if (this.argIndex != that.argIndex) {
            return false;
        }
        return this.referenceContext.equals(that.referenceContext);
    }

    public int hashCode() {
        return 31 * this.argIndex + this.referenceContext.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("argIndex", this.argIndex).add("chain", this.referenceContext).toString();
    }

    void serialize(DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.argIndex);
        DataInputOutputUtilRt.writeSeq((DataOutput)out, this.referenceContext, link -> FunExprOccurrence.serializeLink(out, link));
    }

    static FunExprOccurrence deserialize(DataInput in) throws IOException {
        int argIndex = DataInputOutputUtil.readINT((DataInput)in);
        return new FunExprOccurrence(argIndex, DataInputOutputUtilRt.readSeq((DataInput)in, () -> FunExprOccurrence.deserializeLink(in)));
    }

    private static void serializeLink(DataOutput out, ReferenceChainLink link) throws IOException {
        IOUtil.writeUTF((DataOutput)out, (String)link.referenceName);
        out.writeBoolean(link.isCall);
        if (link.isCall) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)link.argCount);
        }
    }

    @NotNull
    private static ReferenceChainLink deserializeLink(DataInput in) throws IOException {
        boolean isCall;
        String referenceName = IOUtil.readUTF((DataInput)in);
        return new ReferenceChainLink(referenceName, isCall, (isCall = in.readBoolean()) ? DataInputOutputUtil.readINT((DataInput)in) : -1);
    }

    public ThreeState checkHasTypeLight(@NotNull List<? extends PsiClass> samClasses, @NotNull VirtualFile placeFile) {
        int i;
        if (this.referenceContext.isEmpty()) {
            return ThreeState.UNSURE;
        }
        Set<Object> qualifiers = null;
        int maxPossiblePackageComponent = this.referenceContext.size() - 2;
        for (i = 0; i < this.referenceContext.size(); ++i) {
            if (!this.referenceContext.get((int)i).isCall) continue;
            maxPossiblePackageComponent = i - 2;
            break;
        }
        for (i = 0; i < this.referenceContext.size(); ++i) {
            List<? extends PsiMember> candidates;
            ReferenceChainLink link = this.referenceContext.get(i);
            if (qualifiers == null && i > 0 && i <= maxPossiblePackageComponent) continue;
            List<Object> list = candidates = qualifiers == null ? link.getGlobalMembers(placeFile, samClasses.get(0).getProject()) : link.getSymbolMembers(qualifiers);
            if (candidates == null) continue;
            if (i == this.referenceContext.size() - 1) {
                return candidates.isEmpty() ? ThreeState.NO : ThreeState.merge((Iterable)JBIterable.from(candidates).map(m -> this.isCompatible(link, (PsiMember)m, samClasses)));
            }
            qualifiers = ApproximateResolver.getDefiniteSymbolTypes(candidates, qualifiers != null ? qualifiers : Collections.emptySet());
        }
        return ThreeState.UNSURE;
    }

    private ThreeState isCompatible(ReferenceChainLink link, PsiMember member, List<? extends PsiClass> samClasses) {
        if (link.isCall) {
            return member instanceof PsiMethod && this.argIndex >= 0 ? FunExprOccurrence.hasCompatibleParameter((PsiMethod)member, this.argIndex, samClasses) : ThreeState.NO;
        }
        if (member instanceof PsiClass) {
            return ThreeState.fromBoolean((boolean)samClasses.contains(member));
        }
        return member instanceof PsiField ? FunExprOccurrence.canPassFunctionalExpression(samClasses, ((PsiField)member).getType(), (PsiElement)member) : ThreeState.NO;
    }

    public static ThreeState hasCompatibleParameter(PsiMethod method, int argIndex, List<? extends PsiClass> samClasses) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        int paramIndex = method.isVarArgs() ? Math.min(argIndex, parameters2.length - 1) : argIndex;
        return paramIndex < parameters2.length ? FunExprOccurrence.canPassFunctionalExpression(samClasses, parameters2[paramIndex].getType(), (PsiElement)method) : ThreeState.NO;
    }

    private static ThreeState canPassFunctionalExpression(List<? extends PsiClass> samClasses, PsiType type2, PsiElement place) {
        return ThreeState.mostPositive((Iterable)JBIterable.from(samClasses).map(c -> FunExprOccurrence.canPassFunctionalExpression(c, type2, place)));
    }

    private static ThreeState canPassFunctionalExpression(PsiClass sam2, PsiType paramType, PsiElement place) {
        String paramClassName;
        if (paramType instanceof PsiEllipsisType) {
            paramType = ((PsiEllipsisType)paramType).getComponentType();
        }
        String string = paramClassName = paramType instanceof PsiClassType ? ((PsiClassType)paramType).getClassName() : null;
        if (paramClassName == null) {
            return ThreeState.NO;
        }
        if (paramClassName.equals(sam2.getName()) && sam2.getManager().areElementsEquivalent((PsiElement)sam2, (PsiElement)((PsiClassType)paramType).resolve())) {
            return ThreeState.YES;
        }
        if (FunExprOccurrence.isTypeParameterVisible(paramClassName, place) && ((PsiClassType)paramType).resolve() instanceof PsiTypeParameter && FunExprOccurrence.hasSuperTypeAssignableFromSam(sam2, paramType)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static boolean isTypeParameterVisible(String name2, PsiElement fromPlace) {
        JBIterable typeParameters = JBIterable.generate((Object)fromPlace, PsiElement::getContext).takeWhile(c -> !(c instanceof PsiFile)).filter(PsiTypeParameterListOwner.class).flatMap(o -> Arrays.asList(o.getTypeParameters())).map(PsiNamedElement::getName);
        return typeParameters.contains((Object)name2);
    }

    private static boolean hasSuperTypeAssignableFromSam(PsiClass sam2, PsiType type2) {
        return !InheritanceUtil.processSuperTypes((PsiType)type2, (boolean)false, superType -> !InheritanceUtil.isInheritorOrSelf((PsiClass)sam2, (PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)superType), (boolean)true));
    }
}

