/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.model.ModelBranchImpl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements PsiPackage,
Queryable {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;
    private volatile SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return (Collection)this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return (Collection)this.myDirectories.getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(boolean includeLibrarySources) {
        return CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
            ArrayList result = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result);
            this.getFacade().processPackageDirectories(this, this.allScope(), (Processor<? super PsiDirectory>)processor2, includeLibrarySources);
            return CachedValueProvider.Result.create(result, (Object[])PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
    }

    protected PsiPackageImpl findPackage(String qName) {
        return (PsiPackageImpl)this.getFacade().findPackage(qName);
    }

    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    public VirtualFile @NotNull [] occursInPackagePrefixes() {
        return PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
    }

    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public boolean isValid() {
        return !this.getProject().isDisposed() && (PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackage((PsiPackage)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    public PsiClass @NotNull [] getClasses() {
        return this.getClasses(this.allScope());
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        return PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope((Project)this.getProject()));
    }

    public PsiClass @NotNull [] getClasses(@NotNull GlobalSearchScope scope) {
        return this.getFacade().getClasses(this, scope);
    }

    public PsiFile @NotNull [] getFiles(@NotNull GlobalSearchScope scope) {
        return this.getFacade().getPackageFiles(this, scope);
    }

    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new PackageAnnotationValueProvider(), false);
        }
        return (PsiModifierList)this.myAnnotationList.getValue();
    }

    public PsiPackage @NotNull [] getSubPackages() {
        return this.getSubPackages(this.allScope());
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull GlobalSearchScope scope) {
        return this.getFacade().getSubPackages(this, scope);
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance((Project)this.getProject());
    }

    private PsiClass @NotNull [] getCachedClassesByName(@NotNull String name2, GlobalSearchScope scope) {
        PsiClass[] classes2;
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        if (dumbService.isDumb() && dumbService.isAlternativeResolveEnabled()) {
            return this.getCachedClassesInDumbMode(name2, scope);
        }
        if (ModelBranchImpl.hasBranchedFilesInScope((GlobalSearchScope)scope)) {
            return this.findAllClasses(name2, scope);
        }
        Map map2 = (Map)SoftReference.dereference(this.myClassCache);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new SoftReference((Object)map2);
        }
        if ((classes2 = (PsiClass[])map2.get(name2)) != null) {
            return classes2;
        }
        classes2 = this.findAllClasses(name2, (GlobalSearchScope)new EverythingGlobalScope(this.getProject()));
        map2.put(name2, classes2);
        return classes2;
    }

    private PsiClass[] findAllClasses(@NotNull String shortName, GlobalSearchScope scope) {
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + shortName : shortName;
        return this.getFacade().findClasses(classQName, scope);
    }

    private PsiClass[] getCachedClassesInDumbMode(String name2, GlobalSearchScope scope) {
        PsiClass[] classes2;
        HashMap<String, PsiClass[]> map2;
        ConcurrentHashMap scopeMap = (ConcurrentHashMap)SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = new ConcurrentHashMap();
            this.myDumbModeFullCache = new SoftReference(scopeMap);
        }
        if ((map2 = (HashMap<String, PsiClass[]>)scopeMap.get(scope)) == null) {
            PsiClass[] array = this.findClassesHeuristically(name2, scope);
            if (array != null) {
                return array;
            }
            map2 = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                Object[] existing = (PsiClass[])map2.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = (PsiClass[])ArrayUtil.append((Object[])existing, (Object)psiClass);
                }
                map2.put(psiClassName, psiClassArray);
            }
            scopeMap.put(scope, map2);
        }
        return (classes2 = (PsiClass[])map2.get(name2)) == null ? PsiClass.EMPTY_ARRAY : classes2;
    }

    private PsiClass @Nullable [] findClassesHeuristically(String name2, GlobalSearchScope scope) {
        PsiClass[] result;
        if (this.findSubPackageByName(name2) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        ConcurrentHashMap<Pair, PsiClass[]> partial = (ConcurrentHashMap<Pair, PsiClass[]>)SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = new ConcurrentHashMap<Pair, PsiClass[]>();
            this.myDumbModePartialCache = new SoftReference(partial);
        }
        if ((result = (PsiClass[])partial.get(Pair.create((Object)scope, (Object)name2))) == null) {
            ArrayList<PsiClass> fastClasses = new ArrayList<PsiClass>();
            for (PsiDirectory directory : this.getDirectories(scope)) {
                PsiClass[] classes2;
                List sameNamed = ContainerUtil.filter((Object[])directory.getFiles(), file -> file.getName().contains(name2));
                for (PsiClass aClass : classes2 = CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(PsiFile.EMPTY_ARRAY))) {
                    if (!name2.equals(aClass.getName())) continue;
                    fastClasses.add(aClass);
                }
            }
            if (!fastClasses.isEmpty()) {
                result = fastClasses.toArray(PsiClass.EMPTY_ARRAY);
                partial.put(Pair.create((Object)scope, (Object)name2), result);
            }
        }
        return result;
    }

    public boolean containsClassNamed(@NotNull String name2) {
        return this.getCachedClassesByName(name2, (GlobalSearchScope)new EverythingGlobalScope(this.getProject())).length > 0;
    }

    public PsiClass @NotNull [] findClassByShortName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        Object[] allClasses = this.getCachedClassesByName(name2, scope);
        if (allClasses.length == 0) {
            return allClasses;
        }
        if (allClasses.length == 1) {
            return PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)allClasses[0]) ? (PsiClass[])allClasses.clone() : PsiClass.EMPTY_ARRAY;
        }
        return (PsiClass[])((StreamEx)((StreamEx)StreamEx.of((Object[])allClasses).filter(aClass -> PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)aClass))).sorted(PsiClassUtil.createScopeComparator((GlobalSearchScope)scope).thenComparing(c -> c.getQualifiedName(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(c -> {
            PsiFile file = c.getContainingFile();
            return file instanceof PsiJavaFile ? ((PsiJavaFile)file).getPackageName() : "";
        }))).toArray((Object[])PsiClass.EMPTY_ARRAY);
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name2) {
        String qName = this.getQualifiedName();
        String subpackageQName = qName.isEmpty() ? name2 : qName + "." + name2;
        return this.getFacade().findPackage(subpackageQName);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        String providedName;
        GlobalSearchScope scope = place.getResolveScope();
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        Condition nameCondition = (Condition)processor2.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = (NameHint)processor2.getHint(NameHint.KEY);
        String string = providedName = providedNameHint == null ? null : providedNameHint.getName(state);
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes2;
            if (providedName != null) {
                classes2 = this.findClassByShortName(providedName, scope);
                if (classes2.length == 0 && PsiUtil.isInsideJavadocComment((PsiElement)place)) {
                    classes2 = this.findClassByShortName(providedName, this.allScope());
                }
                if (!PsiPackageImpl.processClasses(processor2, state, classes2, (Condition<? super String>)Conditions.alwaysTrue())) {
                    return false;
                }
            } else {
                classes2 = this.getClasses(scope);
                if (classes2.length == 0 && PsiUtil.isInsideJavadocComment((PsiElement)place)) {
                    classes2 = this.getClasses(this.allScope());
                }
                if (!PsiPackageImpl.processClasses(processor2, state, classes2, (Condition<? super String>)(nameCondition != null ? nameCondition : Conditions.alwaysTrue()))) {
                    return false;
                }
            }
        }
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor2.execute((PsiElement)aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel((PsiElement)this)) || processor2.execute((PsiElement)pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiClass @NotNull [] classes2, @NotNull Condition<? super String> nameCondition) {
        for (PsiClass aClass : classes2) {
            String name2 = aClass.getName();
            if (name2 == null || !nameCondition.value((Object)name2)) continue;
            try {
                if (processor2.execute((PsiElement)aClass, state)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }

    public boolean canNavigate() {
        return this.isValid();
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayHaveContentInScope(@NotNull GlobalSearchScope scope) {
        if (this.getDirectories(scope).length > 0) return true;
        if (this.getClasses(scope).length > 0) return true;
        if (!ContainerUtil.exists((Object[])this.occursInPackagePrefixes(), arg_0 -> ((GlobalSearchScope)scope).contains(arg_0))) return false;
        return true;
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name2) {
        return false;
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList modifiers = new ArrayList();
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                PsiFile file = psiDirectory.findFile("package-info.java");
                PsiPackageStatement stmt = file == null ? null : (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)file, PsiPackageStatement.class);
                PsiModifierList modifierList = stmt == null ? null : stmt.getAnnotationList();
                ContainerUtil.addIfNotNull(modifiers, (Object)modifierList);
            }
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull(modifiers, (Object)psiDirectory.getModifierList());
            }
            PsiCompositeModifierList result = modifiers.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers);
            return new CachedValueProvider.Result((Object)result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    }
}

