/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ClsTypeParametersListImpl
extends ClsRepositoryPsiElement<PsiTypeParameterListStub>
implements PsiTypeParameterList {
    public ClsTypeParametersListImpl(@NotNull PsiTypeParameterListStub stub) {
        super(stub);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiTypeParameter[] params = this.getTypeParameters();
        if (params.length != 0) {
            buffer.append('<');
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                ClsTypeParametersListImpl.appendText((PsiElement)params[i], indentLevel, buffer);
            }
            buffer.append(">");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        ClsTypeParametersListImpl.setMirrors((PsiElement[])this.getTypeParameters(), (PsiElement[])((PsiTypeParameterList)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element)).getTypeParameters());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeParameterList((PsiTypeParameterList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiTypeParameter @NotNull [] getTypeParameters() {
        return (PsiTypeParameter[])((PsiTypeParameterListStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.TYPE_PARAMETER, PsiTypeParameter.ARRAY_FACTORY);
    }

    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        assert (typeParameter.getParent() == this);
        return PsiImplUtil.getTypeParameterIndex(typeParameter, this);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiTypeParameter[] typeParameters;
        for (PsiTypeParameter parameter2 : typeParameters = this.getTypeParameters()) {
            if (processor2.execute((PsiElement)parameter2, state)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "PsiTypeParameterList";
    }
}

