/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaPackageAccessibilityStatementElementType;
import com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClsPackageAccessibilityStatementImpl
extends ClsRepositoryPsiElement<PsiPackageAccessibilityStatementStub>
implements PsiPackageAccessibilityStatement {
    private final NullableLazyValue<PsiJavaCodeReferenceElement> myPackageReference = new AtomicNullableLazyValue<PsiJavaCodeReferenceElement>(){

        protected PsiJavaCodeReferenceElement compute() {
            String packageName = ClsPackageAccessibilityStatementImpl.this.getPackageName();
            return packageName != null ? new ClsJavaCodeReferenceElementImpl((PsiElement)ClsPackageAccessibilityStatementImpl.this, packageName) : null;
        }
    };
    private final NotNullLazyValue<Iterable<PsiJavaModuleReferenceElement>> myModuleReferences = new AtomicNotNullLazyValue<Iterable<PsiJavaModuleReferenceElement>>(){

        @NotNull
        protected Iterable<PsiJavaModuleReferenceElement> compute() {
            return ContainerUtil.map(((PsiPackageAccessibilityStatementStub)ClsPackageAccessibilityStatementImpl.this.getStub()).getTargets(), target -> new ClsJavaModuleReferenceElementImpl((PsiElement)ClsPackageAccessibilityStatementImpl.this, (String)target));
        }
    };

    public ClsPackageAccessibilityStatementImpl(PsiPackageAccessibilityStatementStub stub) {
        super(stub);
    }

    @NotNull
    public PsiPackageAccessibilityStatement.Role getRole() {
        return JavaPackageAccessibilityStatementElementType.typeToRole((IElementType)((PsiPackageAccessibilityStatementStub)this.getStub()).getStubType());
    }

    public PsiJavaCodeReferenceElement getPackageReference() {
        return (PsiJavaCodeReferenceElement)this.myPackageReference.getValue();
    }

    public String getPackageName() {
        return StringUtil.nullize((String)((PsiPackageAccessibilityStatementStub)this.getStub()).getPackageName());
    }

    @NotNull
    public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
        return (Iterable)this.myModuleReferences.getValue();
    }

    @NotNull
    public List<String> getModuleNames() {
        return ((PsiPackageAccessibilityStatementStub)this.getStub()).getTargets();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)indentLevel);
        buffer.append(StringUtil.toLowerCase((String)this.getRole().toString())).append(' ').append(this.getPackageName());
        List<String> targets = ((PsiPackageAccessibilityStatementStub)this.getStub()).getTargets();
        if (!targets.isEmpty()) {
            buffer.append(" to ");
            for (int i = 0; i < targets.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(targets.get(i));
            }
        }
        buffer.append(";\n");
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, (IElementType)((PsiPackageAccessibilityStatementStub)this.getStub()).getStubType());
    }

    public String toString() {
        return "PsiPackageAccessibilityStatement[" + this.getRole() + "]";
    }
}

