/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.ModuleStubBuildingVisitor;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.cls.ClsFormatException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClsFileImpl
extends PsiBinaryFileImpl
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance(ClsFileImpl.class);
    private static final String BANNER = "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n";
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create((String)"cls.document.link");
    private final Object myMirrorLock = new Object();
    private final Object myStubLock = new Object();
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile Reference<TreeElement> myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private static final InnerClassSourceStrategy<FileContentPair> STRATEGY = new InnerClassSourceStrategy<FileContentPair>(){

        @Override
        @Nullable
        public FileContentPair findInnerClass(String innerName, FileContentPair outerClass) {
            String baseName = ((VirtualFile)outerClass.first).getNameWithoutExtension();
            VirtualFile dir = ((VirtualFile)outerClass.first).getParent();
            assert (dir != null) : outerClass;
            VirtualFile innerClass = dir.findChild(baseName + '$' + innerName + ".class");
            if (innerClass != null) {
                try {
                    byte[] bytes = innerClass.contentsToByteArray(false);
                    return new FileContentPair(innerClass, bytes);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void accept(FileContentPair innerClass, StubBuildingVisitor<FileContentPair> visitor2) {
            try {
                new ClassReader((byte[])innerClass.second).accept(visitor2, EMPTY_ATTRIBUTES, 4);
            }
            catch (Exception e) {
                VirtualFile file = (VirtualFile)innerClass.first;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(file), (Throwable)e);
                }
                LOG.info(file + ": " + e.getMessage());
            }
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        super((PsiManagerImpl)viewProvider.getManager(), viewProvider);
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return this;
    }

    public boolean isValid() {
        return super.isValid() && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public PsiElement @NotNull [] getChildren() {
        PsiClass[] psiClassArray;
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            PsiElement[] psiElementArray = new PsiElement[1];
            psiClassArray = psiElementArray;
            psiElementArray[0] = module;
        } else {
            psiClassArray = this.getClasses();
        }
        return psiClassArray;
    }

    public PsiClass @NotNull [] getClasses() {
        return this.getStub().getClasses();
    }

    public PsiPackageStatement getPackageStatement() {
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            String packageName;
            statement = ClsPackageStatementImpl.NULL_PACKAGE;
            PsiClassHolderFileStub<?> stub = this.getStub();
            if (!(stub instanceof PsiJavaFileStub && stub.findChildStubByType((IStubElementType)JavaStubElementTypes.MODULE) != null || (packageName = ClsFileImpl.findPackageName(stub)) == null)) {
                statement = new ClsPackageStatementImpl(this, packageName);
            }
            this.myPackageStatement = statement;
        }
        return statement != ClsPackageStatementImpl.NULL_PACKAGE ? statement : null;
    }

    private static String findPackageName(PsiClassHolderFileStub<?> stub) {
        String packageName = null;
        if (stub instanceof PsiJavaFileStub) {
            packageName = ((PsiJavaFileStub)stub).getPackageName();
        } else {
            int index;
            String className2;
            PsiClass[] psiClasses = stub.getClasses();
            if (psiClasses.length > 0 && (className2 = psiClasses[0].getQualifiedName()) != null && (index = className2.lastIndexOf(46)) >= 0) {
                packageName = className2.substring(0, index);
            }
        }
        return !StringUtil.isEmpty((String)packageName) ? packageName : null;
    }

    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        return statement == null ? "" : statement.getPackageName();
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    public PsiImportList getImportList() {
        return null;
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        return PsiClass.EMPTY_ARRAY;
    }

    public String @NotNull [] getImplicitlyImportedPackages() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        PsiClassHolderFileStub<?> stub = this.getStub();
        if (stub instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)stub).getLanguageLevel()) != null) {
            return level;
        }
        return LanguageLevel.HIGHEST;
    }

    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        PsiClassHolderFileStub<?> stub = this.getStub();
        return stub instanceof PsiJavaFileStub ? ((PsiJavaFileStub)stub).getModule() : null;
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException((PsiCompiledElement)this);
    }

    public void checkSetName(String name2) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException((PsiCompiledElement)this);
    }

    @Deprecated
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        this.appendMirrorText(buffer);
    }

    private void appendMirrorText(@NotNull StringBuilder buffer) {
        buffer.append(BANNER);
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            ClsElementImpl.appendText((PsiElement)module, 0, buffer);
        } else {
            ClsElementImpl.appendText((PsiElement)this.getPackageStatement(), 0, buffer, "\n\n");
            PsiClass[] classes2 = this.getClasses();
            if (classes2.length > 0) {
                ClsElementImpl.appendText((PsiElement)classes2[0], 0, buffer);
            }
        }
    }

    @Deprecated
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setFileMirror(element);
    }

    private void setFileMirror(@NotNull TreeElement element) {
        PsiElement mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        PsiJavaModule module = this.getModuleDeclaration();
        if (module != null) {
            ClsElementImpl.setMirror(module, mirrorFile.getModuleDeclaration());
        } else {
            ClsElementImpl.setMirrorIfPresent(this.getPackageStatement(), mirrorFile.getPackageStatement());
            ClsElementImpl.setMirrors((PsiElement[])this.getClasses(), (PsiElement[])mirrorFile.getClasses());
        }
    }

    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
            try {
                Object navigationElement = navigationPolicy instanceof ClsCustomNavigationPolicyEx ? ((ClsCustomNavigationPolicyEx)navigationPolicy).getFileNavigationElement(this) : navigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                return navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
        }
        return (PsiElement)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiElement target = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
            ModificationTracker tracker = FileIndexFacade.getInstance((Project)this.getProject()).getRootModificationTracker();
            return CachedValueProvider.Result.create((Object)target, (Object[])new Object[]{this, target.getContainingFile(), tracker});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = (TreeElement)SoftReference.dereference(this.myMirrorFileElement);
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = (TreeElement)SoftReference.dereference(this.myMirrorFileElement);
                if (mirrorTreeElement == null) {
                    VirtualFile file = this.getVirtualFile();
                    AstLoadingFilter.assertTreeLoadingAllowed((VirtualFile)file);
                    PsiClass[] classes2 = this.getClasses();
                    String fileName = (classes2.length > 0 ? classes2[0].getName() : file.getNameWithoutExtension()) + ".java";
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    assert (document != null) : file.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith((CharSequence)mirrorText, (CharSequence)BANNER);
                    PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getManager().getProject());
                    PsiFile mirror = factory.createFileFromText(fileName, (Language)JavaLanguage.INSTANCE, mirrorText, false, false, true);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, (Object)this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)mirror);
                    try {
                        TreeElement finalMirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            this.setFileMirror(finalMirrorTreeElement);
                            this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file.getUrl(), (Throwable)(internalDecompiler ? e : ClsFileImpl.wrapException(e, file)));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile((PsiFile)this);
                    this.myMirrorFileElement = new SoftReference((Object)mirrorTreeElement);
                }
            }
        }
        return mirrorTreeElement.getPsi();
    }

    public String getText() {
        VirtualFile file = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        assert (document != null) : file.getUrl();
        return document.getText();
    }

    public int getTextLength() {
        VirtualFile file = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        assert (document != null) : file.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file) {
        PluginId pluginId;
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.getInstance().find(file);
        if (decompiler instanceof ClassFileDecompilers.Light && (pluginId = PluginManagerCore.getPluginByClassName((String)decompiler.getClass().getName())) != null) {
            return new PluginException((Throwable)e, pluginId);
        }
        return e;
    }

    public PsiFile getDecompiledPsiFile() {
        return (PsiFile)this.getMirror();
    }

    @Nullable
    public PsiFile getCachedMirror() {
        TreeElement mirrorTreeElement = (TreeElement)SoftReference.dereference(this.myMirrorFileElement);
        return mirrorTreeElement == null ? null : (PsiFile)mirrorTreeElement.getPsi();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor2.visitFile((PsiFile)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    public final TextRange getTextRange() {
        return TextRange.create((int)0, (int)this.getTextLength());
    }

    public final int getStartOffsetInParent() {
        return 0;
    }

    public final PsiElement findElementAt(int offset) {
        return this.getMirror().findElementAt(offset);
    }

    public PsiReference findReferenceAt(int offset) {
        return this.getMirror().findReferenceAt(offset);
    }

    public final int getTextOffset() {
        return 0;
    }

    public char @NotNull [] textToCharArray() {
        return this.getMirror().textToCharArray();
    }

    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        return (PsiClassHolderFileStub)this.getStubTree().getRoot();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes2;
            for (PsiClass aClass : classes2 = this.getClasses()) {
                if (processor2.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = (StubTree)SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            return stubTree;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), (PsiFile)this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree((PsiFileStub)new PsiJavaFileStubImpl("corrupted_class_files", true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = (StubTree)SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                return stubTree;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi((PsiFile)this);
            this.myStub = new SoftReference((Object)stubTree);
        }
        return stubTree;
    }

    @NotNull
    public StubbedSpine getStubbedSpine() {
        return this.getStubTree().getSpine();
    }

    public boolean isContentsLoaded() {
        return this.getCachedMirror() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = (StubTree)SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        object = this.myMirrorLock;
        synchronized (object) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = null;
        }
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiFileImpl.putInfo((PsiFile)this, info);
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file) {
        PsiManager manager = PsiManager.getInstance((Project)DefaultProjectFactory.getInstance().getDefaultProject());
        ClsFileImpl clsFile = new ClsFileImpl((FileViewProvider)new ClassFileViewProvider(manager, file), true);
        StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> clsFile.appendMirrorText(buffer));
        return buffer;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file, byte @NotNull [] bytes) throws ClsFormatException {
        try {
            block10: {
                LanguageLevel level;
                if (ClassFileViewProvider.isInnerClass(file, bytes)) {
                    return null;
                }
                ClassReader reader = new ClassReader(bytes);
                String className2 = file.getNameWithoutExtension();
                String internalName = reader.getClassName();
                boolean module = internalName.equals("module-info") && BitUtil.isSet((int)reader.getAccess(), (int)32768);
                JavaSdkVersion jdkVersion = ClsParsingUtil.getJdkVersionByBytecode(reader.readShort(6));
                LanguageLevel languageLevel = level = jdkVersion != null ? jdkVersion.getMaxLanguageLevel() : null;
                if (module) {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, "", level, true);
                    ModuleStubBuildingVisitor visitor2 = new ModuleStubBuildingVisitor(stub);
                    reader.accept((ClassVisitor)visitor2, EMPTY_ATTRIBUTES, 4);
                    if (visitor2.getResult() != null) {
                        return stub;
                    }
                } else {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, ClsFileImpl.getPackageName(internalName), level, true);
                    try {
                        FileContentPair source = new FileContentPair(file, bytes);
                        StubBuildingVisitor<FileContentPair> visitor3 = new StubBuildingVisitor<FileContentPair>(source, STRATEGY, (StubElement)stub, 0, className2);
                        reader.accept(visitor3, EMPTY_ATTRIBUTES, 4);
                        if (visitor3.getResult() != null) {
                            return stub;
                        }
                    }
                    catch (OutOfOrderInnerClassException e) {
                        if (!LOG.isTraceEnabled()) break block10;
                        LOG.trace(file.getPath());
                    }
                }
            }
            return null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClsFormatException(file.getPath() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }

    static class FileContentPair
    extends Pair<VirtualFile, byte[]> {
        FileContentPair(@NotNull VirtualFile file, byte @NotNull [] content) {
            super((Object)file, (Object)content);
        }

        public byte @NotNull [] getContent() {
            return (byte[])this.second;
        }

        public String toString() {
            return ((VirtualFile)this.first).toString();
        }
    }
}

