/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsDocTagImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ClsDocCommentImpl
extends ClsElementImpl
implements PsiDocComment,
JavaTokenType,
PsiJavaToken {
    private final PsiDocCommentOwner myParent;
    private final PsiDocTag[] myTags;

    ClsDocCommentImpl(@NotNull PsiDocCommentOwner parent) {
        this.myParent = parent;
        this.myTags = new PsiDocTag[]{new ClsDocTagImpl(this, "@deprecated")};
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append("/**");
        for (PsiDocTag tag : this.getTags()) {
            ClsDocCommentImpl.goNextLine(indentLevel + 1, buffer);
            buffer.append("* ");
            buffer.append(tag.getText());
        }
        ClsDocCommentImpl.goNextLine(indentLevel + 1, buffer);
        buffer.append("*/");
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, (IElementType)JavaDocElementType.DOC_COMMENT);
    }

    public PsiElement @NotNull [] getChildren() {
        return this.getTags();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiJavaDocumentedElement getOwner() {
        return PsiImplUtil.findDocCommentOwner(this);
    }

    public PsiElement @NotNull [] getDescriptionElements() {
        return EMPTY_ARRAY;
    }

    public PsiDocTag @NotNull [] getTags() {
        return this.myTags;
    }

    public PsiDocTag findTagByName(@NonNls String name2) {
        return name2.equals("deprecated") ? this.getTags()[0] : null;
    }

    public PsiDocTag @NotNull [] findTagsByName(@NonNls String name2) {
        return name2.equals("deprecated") ? this.getTags() : PsiDocTag.EMPTY_ARRAY;
    }

    @NotNull
    public IElementType getTokenType() {
        return JavaDocElementType.DOC_COMMENT;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDocComment((PsiDocComment)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }
}

